/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.datacenter;

import cn.dustlight.flow.core.exceptions.ErrorDetails;
import cn.dustlight.flow.core.exceptions.ErrorEnum;
import cn.dustlight.flow.core.flow.usertask.UserTaskDataValidator;
import cn.dustlight.flow.core.security.AccessTokenHolder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class DatacenterRecordValidator
implements UserTaskDataValidator {
    private WebClient webClient;
    private AccessTokenHolder accessTokenHolder;
    private ObjectMapper mapper;

    public DatacenterRecordValidator(String baseUrl, AccessTokenHolder accessTokenHolder, ObjectMapper mapper) {
        this.accessTokenHolder = accessTokenHolder;
        this.mapper = mapper;
        this.webClient = WebClient.builder().baseUrl(baseUrl).filter((request, next) -> this.accessTokenHolder.getAccessToken().flatMap(token -> next.exchange(ClientRequest.from((ClientRequest)request).header("Authorization", new String[]{String.format("Bearer %s", token)}).build()))).build();
    }

    public Mono<Boolean> verify(String form, Map<String, Object> data) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/v1/validation", new Object[0])).header("Content-Type", new String[]{"application/json"})).bodyValue((Object)new Record(form, data).toJson()).exchangeToMono(clientResponse -> clientResponse.statusCode() == HttpStatus.OK ? Mono.just((Object)true) : clientResponse.bodyToMono(ErrorDetails.class).map(errorDetails -> ErrorEnum.USER_TASK_DATA_INVALID.details(String.format("(#%d) %s, %s", errorDetails.getCode(), errorDetails.getMessage(), errorDetails.getDetails())).getException()).flatMap(e -> Mono.error((Throwable)e)));
    }

    private class Record {
        private String formName;
        private Map<String, Object> data;

        public String toJson() {
            return DatacenterRecordValidator.this.mapper.writeValueAsString((Object)this);
        }

        public String getFormName() {
            return this.formName;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public void setFormName(String formName) {
            this.formName = formName;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        public Record(String formName, Map<String, Object> data) {
            this.formName = formName;
            this.data = data;
        }
    }
}

