/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.captcha.sender;

import cn.dustlight.captcha.EmailSenderProperties;
import cn.dustlight.captcha.core.Code;
import cn.dustlight.captcha.sender.CodeSender;
import cn.dustlight.captcha.sender.SendCodeException;
import freemarker.template.Template;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.util.StringUtils;

public class EmailCodeSender
implements CodeSender<String> {
    private final EmailSenderProperties properties;
    private final JavaMailSender javaMailSender;
    private final MailProperties mailProperties;
    private TemplateProvider templateProvider;

    public EmailCodeSender(JavaMailSender javaMailSender, MailProperties mailProperties, EmailSenderProperties properties, TemplateProvider templateProvider) {
        this.javaMailSender = javaMailSender;
        this.mailProperties = mailProperties;
        this.properties = properties;
        this.templateProvider = templateProvider;
    }

    public void send(Code<String> code, Map<String, Object> parameters) throws SendCodeException {
        try {
            String template = this.getTemplate(parameters);
            if (template == null) {
                throw new SendCodeException("Email template not found!");
            }
            String emailParamName = this.getEmailParam();
            if (!parameters.containsKey(emailParamName) || parameters.get(emailParamName) == null) {
                throw new SendCodeException(String.format("Parameter '%s' not found!", emailParamName));
            }
            String email = parameters.get(emailParamName).toString();
            MimeMessage message = this.javaMailSender.createMimeMessage();
            MimeMessageHelper h = new MimeMessageHelper(message);
            h.setFrom(this.getFrom(parameters));
            h.setTo(email);
            h.setText(template, this.isHtml(parameters));
            h.setSubject(this.getSubject(parameters));
            this.javaMailSender.send(message);
        }
        catch (Exception e) {
            if (e instanceof SendCodeException) {
                throw (SendCodeException)e;
            }
            throw new SendCodeException("Send Email code error!", (Throwable)e);
        }
    }

    public TemplateProvider getTemplateProvider() {
        return this.templateProvider;
    }

    public void setTemplateProvider(TemplateProvider templateProvider) {
        this.templateProvider = templateProvider;
    }

    protected String getEmailParam() {
        return StringUtils.hasText((String)this.properties.getEmailParamName()) ? this.properties.getEmailParamName() : "email";
    }

    protected String getTemplate(Map<String, Object> parameters) throws Exception {
        if (!parameters.containsKey("TEMPLATE")) {
            return null;
        }
        return this.templateProvider.getTemplateContent((String)parameters.get("TEMPLATE"), parameters);
    }

    protected boolean isHtml(Map<String, Object> parameters) {
        return (Boolean)parameters.getOrDefault("HTML", this.properties.isHtml());
    }

    protected String getSubject(Map<String, Object> parameters) {
        return (String)parameters.getOrDefault("SUBJECT", this.properties.getDefaultSubject());
    }

    protected String getFrom(Map<String, Object> parameters) {
        return (String)parameters.getOrDefault("FROM", this.mailProperties.getUsername());
    }

    public static class DefaultTemplateProvider
    implements TemplateProvider {
        @Override
        public String getTemplateContent(String templateName, Map<String, Object> parameters) throws Exception {
            try (Reader reader = this.getReader(templateName);){
                String string = FreeMarkerTemplateUtils.processTemplateIntoString((Template)new Template(templateName, reader, null), parameters);
                return string;
            }
        }

        protected Reader getReader(String templateName) throws IOException {
            return new BufferedReader(new InputStreamReader(new ClassPathResource(templateName).getInputStream()));
        }
    }

    public static interface TemplateProvider {
        public String getTemplateContent(String var1, Map<String, Object> var2) throws Exception;
    }
}

