package cn.dustlight.captcha.annotations;

import cn.dustlight.captcha.store.CodeStore;

import java.lang.annotation.*;

@Target({ElementType.ANNOTATION_TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
/**
 * 存储器配置
 */
public @interface Store {
    /**
     * 存储器Bean名
     *
     * @return
     */
    String value() default "";

    /**
     * 存储器类型
     *
     * @return
     */
    Class<? extends CodeStore> type() default CodeStore.class;
}
