/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.captcha;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;

public class Util {
    private static final DefaultParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();

    public static <T> T getBean(BeanFactory factory, String name, Class<? extends T> clazz) {
        return (T)factory.getBean(name, clazz);
    }

    public static Map<String, Object> getParameters(Method method, Object[] arguments) {
        String[] names;
        if (arguments == null || (names = parameterNameDiscoverer.getParameterNames(method)) == null) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        int len = Math.min(names.length, arguments.length);
        for (int i = 0; i < len; ++i) {
            parameters.put(names[i], arguments[i]);
        }
        return parameters;
    }

    public static class AnnotationField<T extends Annotation> {
        private T annotation;
        private Field field;

        public T getAnnotation() {
            return this.annotation;
        }

        public void setAnnotation(T annotation) {
            this.annotation = annotation;
        }

        public Field getField() {
            return this.field;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public Object read(Object instance) {
            if (instance == null) {
                return null;
            }
            return new BeanWrapperImpl(instance).getPropertyValue(this.field.getName());
        }

        public void write(Object instance, Object value) {
            if (instance == null) {
                return;
            }
            new BeanWrapperImpl(instance).setPropertyValue(this.field.getName(), value);
        }
    }

    public static class AnnotationFieldFinder<T extends Annotation> {
        private ConcurrentHashMap<Class<?>, Vector<AnnotationField<T>>> cache = new ConcurrentHashMap();
        private Class<T> annotationClazz;
        private static final ConcurrentHashMap<Class<?>, AnnotationFieldFinder> finders = new ConcurrentHashMap();

        public static <T extends Annotation> AnnotationFieldFinder<T> get(Class<T> annotationClazz) {
            if (finders.containsKey(annotationClazz)) {
                return finders.get(annotationClazz);
            }
            AnnotationFieldFinder<T> finder = new AnnotationFieldFinder<T>(annotationClazz);
            finders.put(annotationClazz, finder);
            return finder;
        }

        private AnnotationFieldFinder(Class<T> targetClazz) {
            this.annotationClazz = targetClazz;
        }

        public Vector<AnnotationField<T>> find(Class<?> clazz) {
            if (clazz == null) {
                return null;
            }
            if (this.cache.containsKey(clazz)) {
                return this.cache.get(clazz);
            }
            Vector<AnnotationField<T>> val = this.doProcess(clazz);
            this.cache.put(clazz, val);
            return val;
        }

        protected Vector<AnnotationField<T>> doProcess(Class<?> clazz) {
            Field[] fields;
            Vector<AnnotationField<T>> results = new Vector<AnnotationField<T>>();
            for (Field field : fields = clazz.getDeclaredFields()) {
                T a = field.getAnnotation(this.annotationClazz);
                if (a == null) continue;
                AnnotationField<T> annotationField = new AnnotationField<T>();
                annotationField.setAnnotation(a);
                annotationField.setField(field);
                results.add(annotationField);
            }
            return results;
        }
    }
}

