/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.captcha.sender;

import cn.dustlight.captcha.core.Code;
import cn.dustlight.captcha.sender.CodeSender;
import cn.dustlight.captcha.sender.SendCodeException;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SimpleImageCodeSender<T>
implements CodeSender<T> {
    private ImageHandler imageHandler;
    private int width;
    private int height;

    public SimpleImageCodeSender(ImageHandler imageHandler, int width, int height) {
        this.imageHandler = imageHandler;
        this.width = width;
        this.height = height;
    }

    public SimpleImageCodeSender() {
        this(new DefaultImageHandler(new String[0]), 200, 100);
    }

    @Override
    public void send(Code<T> code, Map<String, Object> parameters) throws SendCodeException {
        if (code == null || code.getValue() == null) {
            throw new SendCodeException("Code is null!");
        }
        BufferedImage image = null;
        try {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletResponse response = requestAttributes.getResponse();
            image = this.imageHandler.getImage(code.getValue().toString(), this.width(parameters), this.height(parameters), parameters);
            response.setStatus(200);
            response.setContentType("image/jpeg");
            ImageIO.write((RenderedImage)image, "jpeg", new BufferedOutputStream((OutputStream)response.getOutputStream()));
        }
        catch (Exception e) {
            throw new SendCodeException("Fail to send code: " + code, e);
        }
        finally {
            try {
                if (image != null) {
                    image.getGraphics().dispose();
                }
            }
            catch (Exception e1) {
                throw new SendCodeException("Dispose image fail", e1);
            }
        }
    }

    private int width(Map<String, Object> parameters) {
        if (parameters == null || !parameters.containsKey("IMAGE_WIDTH") || parameters.get("IMAGE_WIDTH") == null) {
            return this.width;
        }
        return Integer.parseInt(parameters.get("IMAGE_WIDTH").toString());
    }

    private int height(Map<String, Object> parameters) {
        if (parameters == null || !parameters.containsKey("IMAGE_HEIGHT") || parameters.get("IMAGE_HEIGHT") == null) {
            return this.height;
        }
        return Integer.parseInt(parameters.get("IMAGE_HEIGHT").toString());
    }

    public ImageHandler getImageHandler() {
        return this.imageHandler;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setImageHandler(ImageHandler imageHandler) {
        this.imageHandler = imageHandler;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public static class DefaultImageHandler
    implements ImageHandler {
        private SecureRandom secureRandom = new SecureRandom();
        private String font;

        public DefaultImageHandler(String ... fontNames) {
            List<String> availableFonts = null;
            try {
                availableFonts = Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
            }
            catch (NullPointerException e) {
                LoggerFactory.getLogger(this.getClass()).error("GraphicsEnvironment Error", (Throwable)e);
            }
            if (availableFonts != null && fontNames != null) {
                for (String fn : fontNames) {
                    if (fn == null || fn.trim().length() <= 0 || !availableFonts.contains(fn)) continue;
                    this.font = fn;
                    break;
                }
            }
            if (this.font == null || this.font.trim().length() == 0) {
                this.font = "Georgia";
            }
        }

        @Override
        public BufferedImage getImage(String code, int width, int height, Map<String, Object> parameters) {
            int verifySize = code.length();
            BufferedImage image = new BufferedImage(width, height, 1);
            SecureRandom rand = this.secureRandom;
            Graphics2D g2 = image.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color[] colors = new Color[5];
            Color[] colorSpaces = new Color[]{Color.WHITE, Color.CYAN, Color.GRAY, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.YELLOW};
            float[] fractions = new float[colors.length];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = colorSpaces[rand.nextInt(colorSpaces.length)];
                fractions[i] = rand.nextFloat();
            }
            Arrays.sort(fractions);
            g2.setColor(Color.GRAY);
            g2.fillRect(0, 0, width, height);
            Color c = this.getRandColor(200, 250);
            g2.setColor(c);
            g2.fillRect(0, 2, width, height - 4);
            SecureRandom random = this.secureRandom;
            g2.setColor(this.getRandColor(160, 200));
            for (int i = 0; i < 20; ++i) {
                int x = random.nextInt(width - 1);
                int y = random.nextInt(height - 1);
                int xl = random.nextInt(6) + 1;
                int yl = random.nextInt(12) + 1;
                g2.drawLine(x, y, x + xl + 40, y + yl + 20);
            }
            float yawpRate = 0.05f;
            int area = (int)(yawpRate * (float)width * (float)height);
            for (int i = 0; i < area; ++i) {
                int x = random.nextInt(width);
                int y = random.nextInt(height);
                int rgb = this.getRandomIntColor();
                image.setRGB(x, y, rgb);
            }
            this.shear(g2, width, height, c);
            g2.setColor(this.getRandColor(100, 160));
            int fontSize = height - 4;
            Font font = new Font(this.font, 2, fontSize);
            g2.setFont(font);
            char[] chars = code.toCharArray();
            for (int i = 0; i < verifySize; ++i) {
                AffineTransform affine = new AffineTransform();
                affine.setToRotation(0.7853981633974483 * rand.nextDouble() * (double)(rand.nextBoolean() ? 1 : -1), width / verifySize * i + fontSize / 2, height / 2);
                g2.setTransform(affine);
                g2.drawChars(chars, i, 1, (width - 10) / verifySize * i + 5, height / 2 + fontSize / 2 - 10);
            }
            g2.dispose();
            return image;
        }

        private Color getRandColor(int fc, int bc) {
            if (fc > 255) {
                fc = 255;
            }
            if (bc > 255) {
                bc = 255;
            }
            int r = fc + this.secureRandom.nextInt(bc - fc);
            int g = fc + this.secureRandom.nextInt(bc - fc);
            int b = fc + this.secureRandom.nextInt(bc - fc);
            return new Color(r, g, b);
        }

        private int getRandomIntColor() {
            int[] rgb = this.getRandomRgb();
            int color = 0;
            for (int c : rgb) {
                color <<= 8;
                color |= c;
            }
            return color;
        }

        private int[] getRandomRgb() {
            int[] rgb = new int[3];
            for (int i = 0; i < 3; ++i) {
                rgb[i] = this.secureRandom.nextInt(255);
            }
            return rgb;
        }

        private void shear(Graphics g, int w1, int h1, Color color) {
            this.shearX(g, w1, h1, color);
            this.shearY(g, w1, h1, color);
        }

        private void shearX(Graphics g, int w1, int h1, Color color) {
            int period = this.secureRandom.nextInt(2);
            boolean borderGap = true;
            boolean frames = true;
            int phase = this.secureRandom.nextInt(2);
            for (int i = 0; i < h1; ++i) {
                double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
                g.copyArea(0, i, w1, 1, (int)d, 0);
                if (!borderGap) continue;
                g.setColor(color);
                g.drawLine((int)d, i, 0, i);
                g.drawLine((int)d + w1, i, w1, i);
            }
        }

        private void shearY(Graphics g, int w1, int h1, Color color) {
            int period = this.secureRandom.nextInt(40) + 10;
            boolean borderGap = true;
            int frames = 20;
            int phase = 7;
            for (int i = 0; i < w1; ++i) {
                double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
                g.copyArea(i, 0, 1, h1, 0, (int)d);
                if (!borderGap) continue;
                g.setColor(color);
                g.drawLine(i, (int)d, i, 0);
                g.drawLine(i, (int)d + h1, i, h1);
            }
        }
    }

    public static interface ImageHandler {
        public BufferedImage getImage(String var1, int var2, int var3, Map<String, Object> var4);
    }
}

