/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.captcha.core;

import cn.dustlight.captcha.Util;
import cn.dustlight.captcha.annotations.CodeParam;
import cn.dustlight.captcha.annotations.CodeValue;
import cn.dustlight.captcha.annotations.Parameter;
import cn.dustlight.captcha.annotations.VerifyCode;
import cn.dustlight.captcha.configurations.DefaultBeanProperties;
import cn.dustlight.captcha.core.Code;
import cn.dustlight.captcha.store.CodeStore;
import cn.dustlight.captcha.verifier.CodeVerifier;
import cn.dustlight.captcha.verifier.VerifyCodeException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Vector;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class VerifyCodeInterceptor
implements MethodBeforeAdvice,
Ordered {
    public static final String CHANCE_KEY = "CHANCE";
    private BeanFactory factory;
    private int order;
    private DefaultBeanProperties defaultBeanProperties;

    public VerifyCodeInterceptor(DefaultBeanProperties defaultBeanProperties) {
        this.defaultBeanProperties = defaultBeanProperties;
    }

    boolean checkChance(Code code, int chance) {
        if (code.getData().get(CHANCE_KEY) == null) {
            return true;
        }
        Integer CHANCE = Integer.valueOf(code.getData().get(CHANCE_KEY).toString());
        return CHANCE < chance;
    }

    void addChanceCount(Code code) {
        if (code.getData().get(CHANCE_KEY) == null) {
            code.getData().put(CHANCE_KEY, 1);
            return;
        }
        Integer CHANCE = Integer.valueOf(code.getData().get(CHANCE_KEY).toString());
        code.getData().put(CHANCE_KEY, CHANCE + 1);
    }

    public void before(Method method, Object[] objects, Object o) throws Throwable {
        VerifyCode verifyCodeAnnotation = (VerifyCode)AnnotationUtils.findAnnotation((Method)method, VerifyCode.class);
        CodeStore store = !StringUtils.hasText((String)verifyCodeAnnotation.store().value()) ? Util.getBean(this.factory, this.defaultBeanProperties.getStore().getName(), this.defaultBeanProperties.getStore().getType()) : Util.getBean(this.factory, verifyCodeAnnotation.store().value(), verifyCodeAnnotation.store().type());
        CodeVerifier verifier = !StringUtils.hasText((String)verifyCodeAnnotation.verifier().value()) ? Util.getBean(this.factory, this.defaultBeanProperties.getVerifier().getName(), this.defaultBeanProperties.getVerifier().getType()) : Util.getBean(this.factory, verifyCodeAnnotation.verifier().value(), verifyCodeAnnotation.verifier().type());
        Map<String, Object> parameters = Util.getParameters(method, objects);
        for (Parameter parameter : verifyCodeAnnotation.parameters()) {
            parameters.put(parameter.name(), parameter.value());
        }
        Code code = store.load(verifyCodeAnnotation.value(), parameters);
        Object codeValue = code.getValue();
        Object targetValue = parameters.get(verifyCodeAnnotation.value());
        java.lang.reflect.Parameter[] params = method.getParameters();
        if (params != null && objects != null) {
            int len = Math.min(params.length, objects.length);
            for (int i = 0; i < len; ++i) {
                Field f;
                CodeValue codeValueAnnotation = (CodeValue)AnnotationUtils.findAnnotation((AnnotatedElement)params[i], CodeValue.class);
                if (codeValueAnnotation != null && codeValueAnnotation.value().equals(verifyCodeAnnotation.value())) {
                    targetValue = objects[i];
                    objects[i] = codeValue;
                    parameters.put(params[i].getName(), codeValue);
                    continue;
                }
                CodeParam codeParamAnnotation = (CodeParam)AnnotationUtils.findAnnotation((AnnotatedElement)params[i], CodeParam.class);
                if (codeParamAnnotation != null && codeParamAnnotation.value().equals(verifyCodeAnnotation.value())) {
                    Object value;
                    String key = codeParamAnnotation.value().length() > 0 ? codeParamAnnotation.value() : params[i].getName();
                    Object object = value = code.getData() == null ? null : code.getData().get(key);
                    if (value == null && params[i].getType().isAssignableFrom(String.class)) {
                        value = codeParamAnnotation.defaultValue();
                    }
                    objects[i] = code.getData().getOrDefault(key, value);
                    continue;
                }
                if (objects[i] == null) continue;
                Class<?> paramType = params[i].getType();
                Vector<Util.AnnotationField<CodeValue>> codeValues = Util.AnnotationFieldFinder.get(CodeValue.class).find(paramType);
                Vector<Util.AnnotationField<CodeParam>> codeParams = Util.AnnotationFieldFinder.get(CodeParam.class).find(paramType);
                if (codeValues != null) {
                    for (Util.AnnotationField<Annotation> annotationField : codeValues) {
                        if (!((CodeValue)annotationField.getAnnotation()).value().equals(verifyCodeAnnotation.value())) continue;
                        f = annotationField.getField();
                        targetValue = annotationField.read(objects[i]);
                        annotationField.write(objects[i], codeValue);
                        parameters.put(f.getName(), codeValue);
                    }
                }
                if (codeParams == null) continue;
                for (Util.AnnotationField<Annotation> annotationField : codeParams) {
                    Object value;
                    if (!((CodeParam)annotationField.getAnnotation()).value().equals(verifyCodeAnnotation.value())) continue;
                    f = annotationField.getField();
                    String key = ((CodeParam)annotationField.getAnnotation()).value().length() > 0 ? ((CodeParam)annotationField.getAnnotation()).value() : f.getName();
                    Object object = value = code.getData() == null ? null : code.getData().get(key);
                    if (value == null && f.getType().isAssignableFrom(String.class)) {
                        value = ((CodeParam)annotationField.getAnnotation()).defaultValue();
                    }
                    annotationField.write(objects[i], code.getData().getOrDefault(key, value));
                }
            }
        }
        try {
            verifier.verify(code, targetValue, parameters);
            store.remove(verifyCodeAnnotation.value());
        }
        catch (VerifyCodeException e) {
            this.addChanceCount(code);
            if (this.checkChance(code, verifyCodeAnnotation.delete().onFail())) {
                store.store(code, null, parameters);
            } else {
                store.remove(verifyCodeAnnotation.value());
            }
            throw e;
        }
    }

    public BeanFactory getFactory() {
        return this.factory;
    }

    public void setFactory(BeanFactory factory) {
        this.factory = factory;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

