/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.captcha.verifier;

import cn.dustlight.captcha.CaptchaException;
import cn.dustlight.captcha.core.Code;
import cn.dustlight.captcha.verifier.CodeVerifier;
import cn.dustlight.captcha.verifier.VerifyCodeException;
import cn.dustlight.captcha.verifier.VerifyFailException;
import java.util.Map;

public class StringCodeVerifier
implements CodeVerifier<String> {
    private StringVerifierHandler handler;

    public StringCodeVerifier(StringVerifierHandler handler) {
        this.handler = handler;
    }

    public StringCodeVerifier() {
        this.handler = new StringEqualsVerifierHandler(false, true, false);
    }

    @Override
    public void verify(Code<String> code, String target, Map<String, Object> parameters) throws VerifyCodeException {
        try {
            String c = code == null || code.getValue() == null ? null : code.getValue();
            String t = target;
            if (!this.handler.verify(c, t)) {
                throw new VerifyFailException("Fail to verify code.");
            }
        }
        catch (Exception e) {
            if (e instanceof CaptchaException) {
                throw e;
            }
            throw new VerifyCodeException("Fail to verify code.", e);
        }
    }

    public StringVerifierHandler getHandler() {
        return this.handler;
    }

    public void setHandler(StringVerifierHandler handler) {
        this.handler = handler;
    }

    public static class StringEqualsVerifierHandler
    implements StringVerifierHandler {
        private boolean enabledNull;
        private boolean trim;
        private boolean caseSensitive;

        public StringEqualsVerifierHandler(boolean enabledNull, boolean trim, boolean caseSensitive) {
            this.enabledNull = enabledNull;
            this.trim = trim;
            this.caseSensitive = caseSensitive;
        }

        @Override
        public boolean verify(String code, String target) {
            if (code == null || target == null) {
                return this.enabledNull ? code == target : false;
            }
            return this.trim ? code.trim().equals(target.trim()) : code.equals(target);
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public void setTrim(boolean trim) {
            this.trim = trim;
        }

        public boolean isTrim() {
            return this.trim;
        }

        public void setEnabledNull(boolean enabledNull) {
            this.enabledNull = enabledNull;
        }

        public boolean isEnabledNull() {
            return this.enabledNull;
        }
    }

    public static interface StringVerifierHandler {
        public boolean verify(String var1, String var2);
    }
}

