/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.captcha.generator;

import cn.dustlight.captcha.core.Code;
import cn.dustlight.captcha.core.DefaultCode;
import cn.dustlight.captcha.generator.CodeGenerator;
import cn.dustlight.captcha.generator.GenerateCodeException;
import java.security.SecureRandom;
import java.util.Map;

public class RandomStringCodeGenerator
implements CodeGenerator<String> {
    public static final char[] DEFAULT_CHARACTERS = "0123456789qwertyuiopasdfghjklzxcvbnm".toCharArray();
    private SecureRandom secureRandom = new SecureRandom();
    private char[] chars;
    private int length;

    public RandomStringCodeGenerator(char[] chars, int length) {
        this.chars = chars;
        this.length = length;
    }

    public RandomStringCodeGenerator() {
        this(DEFAULT_CHARACTERS, 4);
    }

    @Override
    public Code<String> generate(String name, Map<String, Object> parameters) throws GenerateCodeException {
        try {
            int len = this.length;
            char[] chars = this.chars;
            StringBuilder builder = new StringBuilder(this.length);
            for (int i = 0; i < len; ++i) {
                builder.append(chars[this.secureRandom.nextInt(chars.length)]);
            }
            DefaultCode<String> code = new DefaultCode<String>(builder.toString());
            code.setName(name);
            return code;
        }
        catch (Exception e) {
            throw new GenerateCodeException("Fail to generate code", e);
        }
    }

    public void setChars(char[] chars) {
        this.chars = chars;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public char[] getChars() {
        return this.chars;
    }

    public int getLength() {
        return this.length;
    }
}

