/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.captcha.core;

import cn.dustlight.captcha.Util;
import cn.dustlight.captcha.annotations.CodeParam;
import cn.dustlight.captcha.annotations.CodeValue;
import cn.dustlight.captcha.annotations.Parameter;
import cn.dustlight.captcha.annotations.SendCode;
import cn.dustlight.captcha.configurations.DefaultBeanProperties;
import cn.dustlight.captcha.core.Code;
import cn.dustlight.captcha.generator.CodeGenerator;
import cn.dustlight.captcha.sender.CodeSender;
import cn.dustlight.captcha.store.CodeStore;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class SendCodeInterceptor
implements MethodBeforeAdvice,
Ordered {
    private BeanFactory factory;
    private int order;
    private DefaultBeanProperties defaultBeanProperties;

    public SendCodeInterceptor(DefaultBeanProperties defaultBeanProperties) {
        this.defaultBeanProperties = defaultBeanProperties;
    }

    public void before(Method method, Object[] objects, Object o) throws Throwable {
        SendCode sendCodeAnnotation = (SendCode)AnnotationUtils.findAnnotation((Method)method, SendCode.class);
        CodeGenerator generator = !StringUtils.hasText((String)sendCodeAnnotation.generator().value()) ? Util.getBean(this.factory, this.defaultBeanProperties.getGenerator().getName(), this.defaultBeanProperties.getGenerator().getType()) : Util.getBean(this.factory, sendCodeAnnotation.generator().value(), sendCodeAnnotation.generator().type());
        CodeStore store = !StringUtils.hasText((String)sendCodeAnnotation.store().value()) ? Util.getBean(this.factory, this.defaultBeanProperties.getStore().getName(), this.defaultBeanProperties.getStore().getType()) : Util.getBean(this.factory, sendCodeAnnotation.store().value(), sendCodeAnnotation.store().type());
        CodeSender sender = !StringUtils.hasText((String)sendCodeAnnotation.sender().value()) ? Util.getBean(this.factory, this.defaultBeanProperties.getSender().getName(), this.defaultBeanProperties.getSender().getType()) : Util.getBean(this.factory, sendCodeAnnotation.sender().value(), sendCodeAnnotation.sender().type());
        Map<String, Object> parameters = Util.getParameters(method, objects);
        for (Parameter parameter : sendCodeAnnotation.parameters()) {
            parameters.put(parameter.name(), parameter.value());
        }
        Code code = generator.generate(sendCodeAnnotation.value(), parameters);
        Object codeValue = code.getValue();
        java.lang.reflect.Parameter[] params = method.getParameters();
        if (params != null && objects != null) {
            int len = Math.min(params.length, objects.length);
            for (int i = 0; i < len; ++i) {
                CodeValue codeValueAnnotation = (CodeValue)AnnotationUtils.findAnnotation((AnnotatedElement)params[i], CodeValue.class);
                if (codeValueAnnotation != null && codeValueAnnotation.value().equals(sendCodeAnnotation.value())) {
                    objects[i] = codeValue;
                    parameters.put(params[i].getName(), codeValue);
                    continue;
                }
                CodeParam codeParamAnnotation = (CodeParam)AnnotationUtils.findAnnotation((AnnotatedElement)params[i], CodeParam.class);
                if (codeParamAnnotation == null || !codeParamAnnotation.value().equals(sendCodeAnnotation.value())) continue;
                String key = codeParamAnnotation.value().length() > 0 ? codeParamAnnotation.value() : params[i].getName();
                Object value = objects[i] != null ? objects[i] : codeParamAnnotation.defaultValue();
                code.getData().put(key, value);
            }
        }
        store.store(code, sendCodeAnnotation.duration(), parameters);
        sender.send(code, parameters);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public BeanFactory getFactory() {
        return this.factory;
    }

    public void setFactory(BeanFactory factory) {
        this.factory = factory;
    }
}

