/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.captcha.configurations;

import cn.dustlight.captcha.annotations.EnableCaptcha;
import cn.dustlight.captcha.configurations.DefaultBeanProperties;
import cn.dustlight.captcha.core.SendCodePostProcessor;
import cn.dustlight.captcha.core.VerifyCodePostProcessor;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
@EnableConfigurationProperties(value={DefaultBeanProperties.class})
public class CaptchaConfiguration
implements ImportAware {
    @Nullable
    protected AnnotationAttributes attrs;

    public void setImportMetadata(AnnotationMetadata annotationMetadata) {
        this.attrs = AnnotationAttributes.fromMap((Map)annotationMetadata.getAnnotationAttributes(EnableCaptcha.class.getName(), false));
        if (this.attrs == null) {
            throw new IllegalArgumentException("@EnableValidator is not present on importing class " + annotationMetadata.getClassName());
        }
    }

    @Bean
    @Role(value=2)
    public SendCodePostProcessor sendCodePostProcessor(@Autowired DefaultBeanProperties defaultBeanProperties) {
        SendCodePostProcessor sendCodePostProcessor = new SendCodePostProcessor(defaultBeanProperties);
        if (this.attrs != null) {
            sendCodePostProcessor.setProxyTargetClass(this.attrs.getBoolean("proxyTargetClass"));
            sendCodePostProcessor.setOrder((Integer)this.attrs.getNumber("orderOfSend"));
        }
        return sendCodePostProcessor;
    }

    @Bean
    @Role(value=2)
    public VerifyCodePostProcessor verifyCodePostProcessor(@Autowired DefaultBeanProperties defaultBeanProperties) {
        VerifyCodePostProcessor verifyCodePostProcessor = new VerifyCodePostProcessor(defaultBeanProperties);
        if (this.attrs != null) {
            verifyCodePostProcessor.setProxyTargetClass(this.attrs.getBoolean("proxyTargetClass"));
            verifyCodePostProcessor.setOrder((Integer)this.attrs.getNumber("orderOfVerify"));
        }
        return verifyCodePostProcessor;
    }
}

