/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.upload;

import cn.dreampie.common.http.HttpRequest;
import cn.dreampie.common.http.UploadedFile;
import cn.dreampie.common.http.exception.WebException;
import cn.dreampie.common.util.Lister;
import cn.dreampie.common.util.stream.FileRenamer;
import cn.dreampie.log.Logger;
import cn.dreampie.upload.multipart.FilePart;
import cn.dreampie.upload.multipart.MultipartParser;
import cn.dreampie.upload.multipart.ParamPart;
import cn.dreampie.upload.multipart.Part;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartRequest {
    private static final Logger logger = Logger.getLogger(MultipartRequest.class);
    private static final int DEFAULT_MAX_POST_SIZE = 0x100000;
    protected Hashtable<String, List<String>> params = new Hashtable();
    protected Hashtable<String, UploadedFile> files = new Hashtable();

    public MultipartRequest(HttpRequest request, String saveDirectory) throws IOException {
        this(request, saveDirectory, 0x100000);
    }

    public MultipartRequest(HttpRequest request, String saveDirectory, int maxPostSize) throws IOException {
        this(request, saveDirectory, maxPostSize, null, null);
    }

    public MultipartRequest(HttpRequest request, String saveDirectory, String encoding) throws IOException {
        this(request, saveDirectory, 0x100000, encoding, null);
    }

    public MultipartRequest(HttpRequest request, String saveDirectory, int maxPostSize, FileRenamer renamer) throws IOException {
        this(request, saveDirectory, maxPostSize, null, renamer);
    }

    public MultipartRequest(HttpRequest request, String saveDirectory, int maxPostSize, String encoding) throws IOException {
        this(request, saveDirectory, maxPostSize, encoding, null);
    }

    public MultipartRequest(HttpRequest request, String saveDirectory, int maxPostSize, String encoding, FileRenamer renamer) throws IOException {
        this(request, new File(saveDirectory), maxPostSize, encoding, renamer, null, null);
    }

    public MultipartRequest(HttpRequest request, File saveDirectory, int maxPostSize, String encoding, FileRenamer renamer, String[] allows, String[] denieds) throws IOException {
        Part part;
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null.");
        }
        if (maxPostSize <= 0) {
            throw new IllegalArgumentException("MaxPostSize must be positive.");
        }
        if (!saveDirectory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + saveDirectory);
        }
        if (!saveDirectory.canWrite()) {
            throw new IOException("Not writable: " + saveDirectory);
        }
        MultipartParser parser = new MultipartParser(request, maxPostSize, true, true, encoding);
        List deniedTypes = Lister.of((Object[])denieds);
        List allowTypes = Lister.of((Object[])allows);
        while ((part = parser.readNextPart()) != null) {
            String name = part.getName();
            if (part.isParam()) {
                ParamPart paramPart = (ParamPart)part;
                String value = paramPart.getStringValue();
                Vector<String> existingValues = (Vector<String>)this.params.get(name);
                if (existingValues == null) {
                    existingValues = new Vector<String>();
                    this.params.put(name, existingValues);
                }
                existingValues.addElement(value);
                continue;
            }
            if (!part.isFile()) continue;
            FilePart filePart = (FilePart)part;
            String contentType = filePart.getContentType();
            if (allowTypes.size() > 0 && !allowTypes.contains(contentType) || deniedTypes.size() > 0 && deniedTypes.contains(contentType)) {
                throw new WebException("Denied upload file type '" + filePart.getContentType() + "'.");
            }
            String fileName = filePart.getFileName();
            if (fileName != null) {
                filePart.setRenamer(renamer);
                filePart.writeTo(saveDirectory);
                this.files.put(name, new UploadedFile(filePart.getDir().toString(), filePart.getFileName(), fileName, filePart.getContentType()));
                logger.info("Upload success. file \"%s\" type \"%s\"", new Object[]{filePart.getFileName(), filePart.getContentType()});
                continue;
            }
            this.files.put(name, new UploadedFile(null, null, null, null));
            logger.warn("Upload empty file %s.", new Object[]{name});
        }
    }

    public Enumeration getFileNames() {
        return this.files.keys();
    }

    public String getFilesystemName(String name) {
        try {
            UploadedFile file = this.files.get(name);
            return file.getFileName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getOriginalFileName(String name) {
        try {
            UploadedFile file = this.files.get(name);
            return file.getOriginalFileName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getContentType(String name) {
        try {
            UploadedFile file = this.files.get(name);
            return file.getContentType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public File getFile(String name) {
        try {
            UploadedFile file = this.files.get(name);
            return file.getFile();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Hashtable<String, UploadedFile> getFiles() {
        return this.files;
    }

    public Hashtable<String, List<String>> getParams() {
        return this.params;
    }
}

