/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm.provider.jndi;

import cn.dreampie.orm.dialect.Dialect;
import cn.dreampie.orm.dialect.DialectFactory;
import cn.dreampie.orm.exception.DBException;
import cn.dreampie.orm.provider.DataSourceProvider;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JndiDataSourceProvider
implements DataSourceProvider {
    private DataSource ds;
    private Dialect dialect;
    private String dsName;
    private boolean showSql;

    public JndiDataSourceProvider(String jndiName) {
        this(jndiName, false);
    }

    public JndiDataSourceProvider(String jndiName, boolean showSql) {
        this("default", jndiName, showSql);
    }

    public JndiDataSourceProvider(String dsName, String jndiName) {
        this(dsName, jndiName, false);
    }

    public JndiDataSourceProvider(String dsName, String jndiName, boolean showSql) {
        this(dsName, jndiName, null, showSql);
    }

    public JndiDataSourceProvider(String dsName, String jndiName, String dialect) {
        this(dsName, jndiName, dialect, false);
    }

    public JndiDataSourceProvider(String dsName, String jndiName, String dialect, boolean showSql) {
        this.dsName = dsName;
        try {
            InitialContext ctx = new InitialContext();
            this.ds = (DataSource)ctx.lookup(jndiName);
            if (this.ds == null) {
                throw new DBException("Jndi could not found error for " + jndiName);
            }
        }
        catch (NamingException e) {
            throw new DBException(e.getMessage(), e);
        }
        this.dialect = DialectFactory.get(dialect == null ? "mysql" : dialect);
        this.showSql = showSql;
    }

    @Override
    public DataSource getDataSource() {
        return this.ds;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public String getDsName() {
        return this.dsName;
    }

    @Override
    public boolean isShowSql() {
        return this.showSql;
    }

    public JndiDataSourceProvider setShowSql(boolean showSql) {
        this.showSql = showSql;
        return this;
    }

    @Override
    public void close() {
    }
}

