/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm.provider.druid;

import cn.dreampie.common.util.Checker;
import cn.dreampie.common.util.properties.Prop;
import cn.dreampie.common.util.properties.Proper;
import cn.dreampie.orm.dialect.Dialect;
import cn.dreampie.orm.dialect.DialectFactory;
import cn.dreampie.orm.provider.DataSourceProvider;
import com.alibaba.druid.DruidRuntimeException;
import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

public class DruidDataSourceProvider
implements DataSourceProvider {
    private String dsName;
    private String url;
    private String user;
    private String password;
    private String driverClass;
    private int initialSize = 10;
    private int minIdle = 10;
    private int maxActive = 100;
    private long maxWait = -1L;
    private long timeBetweenEvictionRunsMillis = 60000L;
    private long minEvictableIdleTimeMillis = 1800000L;
    private long timeBetweenConnectErrorMillis = 30000L;
    private boolean testWhileIdle = true;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private boolean removeAbandoned = false;
    private long removeAbandonedTimeoutMillis = 300000L;
    private boolean logAbandoned = false;
    private int maxPoolPreparedStatementPerConnectionSize = 10;
    private String filters;
    private String validationQuery = "select 1";
    private DruidDataSource ds;
    private Dialect dialect;
    private boolean showSql = false;

    public DruidDataSourceProvider() {
        this("default");
    }

    public DruidDataSourceProvider(String dsName) {
        this.dsName = dsName;
        Prop prop = Proper.use((String)"application.properties");
        this.url = prop.get("db." + dsName + ".url");
        Checker.checkNotNull((Object)this.url, (Object)("Could not found database url for db." + dsName + ".url"));
        this.user = prop.get("db." + dsName + ".user");
        Checker.checkNotNull((Object)this.user, (Object)("Could not found database user for db." + dsName + ".user"));
        this.password = prop.get("db." + dsName + ".password");
        Checker.checkNotNull((Object)this.password, (Object)("Could not found database password for db." + dsName + ".password"));
        this.dialect = DialectFactory.get(prop.get("db." + dsName + ".dialect", "mysql"));
        this.driverClass = prop.get("db." + dsName + ".driver", this.dialect.driverClass());
        this.showSql = prop.getBoolean("db." + dsName + ".showSql", Boolean.valueOf(false));
        this.filters = prop.get("druid." + dsName + ".filters");
        this.initialSize = prop.getInt("druid." + dsName + ".initialSize", Integer.valueOf(10));
        this.minIdle = prop.getInt("druid." + dsName + ".minIdle", Integer.valueOf(10));
        this.maxActive = prop.getInt("druid." + dsName + ".maxActive", Integer.valueOf(100));
        this.maxWait = prop.getInt("druid." + dsName + ".maxWait", Integer.valueOf(-1)).intValue();
        this.timeBetweenEvictionRunsMillis = prop.getLong("druid." + dsName + ".timeBetweenEvictionRunsMillis", Long.valueOf(60000L));
        this.minEvictableIdleTimeMillis = prop.getLong("druid." + dsName + ".minEvictableIdleTimeMillis", Long.valueOf(1800000L));
        this.timeBetweenConnectErrorMillis = prop.getLong("druid." + dsName + ".timeBetweenConnectErrorMillis", Long.valueOf(30000L));
        this.testWhileIdle = prop.getBoolean("druid." + dsName + ".testWhileIdle", Boolean.valueOf(true));
        this.testOnBorrow = prop.getBoolean("druid." + dsName + ".testOnBorrow", Boolean.valueOf(false));
        this.testOnReturn = prop.getBoolean("druid." + dsName + ".testOnReturn", Boolean.valueOf(false));
        this.removeAbandoned = prop.getBoolean("druid." + dsName + ".removeAbandoned", Boolean.valueOf(false));
        this.removeAbandonedTimeoutMillis = prop.getInt("druid." + dsName + ".removeAbandonedTimeoutMillis", Integer.valueOf(300000)).intValue();
        this.logAbandoned = prop.getBoolean("druid." + dsName + ".logAbandoned", Boolean.valueOf(false));
        this.maxPoolPreparedStatementPerConnectionSize = prop.getInt("druid." + dsName + ".maxPoolPreparedStatementPerConnectionSize", Integer.valueOf(10));
        this.validationQuery = prop.get("druid." + dsName + ".validationQuery", this.dialect.validQuery());
        this.buidDataSource();
    }

    public DruidDataSourceProvider(String url, String user, String password) {
        this(url, user, password, false);
    }

    public DruidDataSourceProvider(String url, String user, String password, boolean showSql) {
        this(url, user, password, null, showSql);
    }

    public DruidDataSourceProvider(String url, String user, String password, String dbType, boolean showSql) {
        this(url, user, password, dbType, null, showSql);
    }

    public DruidDataSourceProvider(String url, String user, String password, String dbType, String driverClass, boolean showSql) {
        this.url = url;
        Checker.checkNotNull((Object)this.url, (Object)"Could not found database url for custom.");
        this.user = user;
        Checker.checkNotNull((Object)this.user, (Object)"Could not found database user for custom.");
        this.password = password;
        Checker.checkNotNull((Object)this.password, (Object)"Could not found database password for custom.");
        this.dialect = DialectFactory.get(dbType);
        this.driverClass = driverClass == null ? this.dialect.driverClass() : driverClass;
        this.showSql = showSql;
        this.buidDataSource();
    }

    private void buidDataSource() {
        this.ds = new DruidDataSource();
        this.ds.setUrl(this.url);
        this.ds.setUsername(this.user);
        this.ds.setPassword(this.password);
        if (this.driverClass != null) {
            this.ds.setDriverClassName(this.driverClass);
        }
        this.ds.setInitialSize(this.initialSize);
        this.ds.setMinIdle(this.minIdle);
        this.ds.setMaxActive(this.maxActive);
        this.ds.setMaxWait(this.maxWait);
        this.ds.setTimeBetweenConnectErrorMillis(this.timeBetweenConnectErrorMillis);
        this.ds.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        this.ds.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        this.ds.setValidationQuery(this.validationQuery);
        this.ds.setTestWhileIdle(this.testWhileIdle);
        this.ds.setTestOnBorrow(this.testOnBorrow);
        this.ds.setTestOnReturn(this.testOnReturn);
        this.ds.setRemoveAbandoned(this.removeAbandoned);
        this.ds.setRemoveAbandonedTimeoutMillis(this.removeAbandonedTimeoutMillis);
        this.ds.setLogAbandoned(this.logAbandoned);
        this.ds.setMaxPoolPreparedStatementPerConnectionSize(this.maxPoolPreparedStatementPerConnectionSize);
        if (this.filters != null) {
            try {
                this.ds.setFilters(this.filters);
            }
            catch (SQLException e) {
                throw new DruidRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.ds;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public String getDsName() {
        return this.dsName;
    }

    @Override
    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    @Override
    public void close() {
        this.ds.close();
    }

    public DruidDataSourceProvider setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        this.ds.setDriverClassName(driverClass);
        return this;
    }

    public DruidDataSourceProvider setInitialSize(int initialSize) {
        this.initialSize = initialSize;
        this.ds.setInitialSize(initialSize);
        return this;
    }

    public DruidDataSourceProvider setMinIdle(int minIdle) {
        this.minIdle = minIdle;
        this.ds.setMinIdle(minIdle);
        return this;
    }

    public DruidDataSourceProvider setMaxActive(int maxActive) {
        this.maxActive = maxActive;
        this.ds.setMaxActive(maxActive);
        return this;
    }

    public DruidDataSourceProvider setMaxWait(long maxWait) {
        this.maxWait = maxWait;
        this.ds.setMaxWait(maxWait);
        return this;
    }

    public DruidDataSourceProvider setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this.ds.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
        return this;
    }

    public DruidDataSourceProvider setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        this.ds.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
        return this;
    }

    public DruidDataSourceProvider setTimeBetweenConnectErrorMillis(long timeBetweenConnectErrorMillis) {
        this.timeBetweenConnectErrorMillis = timeBetweenConnectErrorMillis;
        this.ds.setTimeBetweenConnectErrorMillis(timeBetweenConnectErrorMillis);
        return this;
    }

    public DruidDataSourceProvider setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
        this.ds.setValidationQuery(validationQuery);
        return this;
    }

    public DruidDataSourceProvider setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        this.ds.setTestWhileIdle(testWhileIdle);
        return this;
    }

    public DruidDataSourceProvider setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        this.ds.setTestOnBorrow(testOnBorrow);
        return this;
    }

    public DruidDataSourceProvider setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        this.ds.setTestOnReturn(testOnReturn);
        return this;
    }

    public DruidDataSourceProvider setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
        this.ds.setRemoveAbandoned(removeAbandoned);
        return this;
    }

    public DruidDataSourceProvider setRemoveAbandonedTimeoutMillis(long removeAbandonedTimeoutMillis) {
        this.removeAbandonedTimeoutMillis = removeAbandonedTimeoutMillis;
        this.ds.setRemoveAbandonedTimeoutMillis(removeAbandonedTimeoutMillis);
        return this;
    }

    public DruidDataSourceProvider setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
        this.ds.setLogAbandoned(logAbandoned);
        return this;
    }

    public DruidDataSourceProvider setMaxPoolPreparedStatementPerConnectionSize(int maxPoolPreparedStatementPerConnectionSize) {
        this.maxPoolPreparedStatementPerConnectionSize = maxPoolPreparedStatementPerConnectionSize;
        this.ds.setMaxPoolPreparedStatementPerConnectionSize(maxPoolPreparedStatementPerConnectionSize);
        return this;
    }

    public DruidDataSourceProvider setFilters(String filters) {
        this.filters = filters;
        try {
            this.ds.setFilters(filters);
        }
        catch (SQLException e) {
            throw new DruidRuntimeException(e.getMessage(), (Throwable)e);
        }
        return this;
    }

    public DruidDataSourceProvider addFilter(Filter ... filters) {
        List targetList = this.ds.getProxyFilters();
        for (Filter add : filters) {
            boolean found = false;
            for (Filter target : targetList) {
                if (!add.getClass().equals(target.getClass())) continue;
                found = true;
                break;
            }
            if (found) continue;
            targetList.add(add);
        }
        return this;
    }
}

