/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm.provider.c3p0;

import cn.dreampie.common.util.Checker;
import cn.dreampie.common.util.properties.Prop;
import cn.dreampie.common.util.properties.Proper;
import cn.dreampie.orm.dialect.Dialect;
import cn.dreampie.orm.dialect.DialectFactory;
import cn.dreampie.orm.exception.DBException;
import cn.dreampie.orm.provider.DataSourceProvider;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import java.beans.PropertyVetoException;
import java.sql.SQLException;
import javax.sql.DataSource;

public class C3p0DataSourceProvider
implements DataSourceProvider {
    private String dsName;
    private String url;
    private String user;
    private String password;
    private String driverClass;
    private boolean showSql = false;
    private int maxStatements = 0;
    private int maxStatementsPerConnection = 0;
    private int initialPoolSize = 3;
    private int minPoolSize = 3;
    private int maxPoolSize = 15;
    private int idleConnectionTestPeriod = 0;
    private int maxIdleTime = 0;
    private int propertyCycle = 0;
    private int acquireIncrement = 3;
    private int acquireRetryAttempts = 30;
    private int acquireRetryDelay = 1000;
    private int checkoutTimeout = 0;
    private int maxAdministrativeTaskTime = 0;
    private int maxIdleTimeExcessConnections = 0;
    private int maxConnectionAge = 0;
    private int unreturnedConnectionTimeout = 0;
    private boolean breakAfterAcquireFailure = false;
    private boolean testConnectionOnCheckout = false;
    private boolean testConnectionOnCheckin = false;
    private boolean autoCommitOnClose = false;
    private String automaticTestTable = null;
    private String preferredTestQuery = "select 1";
    private ComboPooledDataSource ds;
    private Dialect dialect;

    public C3p0DataSourceProvider() {
        this("default");
    }

    public C3p0DataSourceProvider(String dsName) {
        this.dsName = dsName;
        Prop prop = Proper.use((String)"application.properties");
        this.url = prop.get("db." + dsName + ".url");
        Checker.checkNotNull((Object)this.url, (Object)("Could not found database url for db." + dsName + ".url"));
        this.user = prop.get("db." + dsName + ".user");
        Checker.checkNotNull((Object)this.user, (Object)("Could not found database user for db." + dsName + ".user"));
        this.password = prop.get("db." + dsName + ".password");
        Checker.checkNotNull((Object)this.password, (Object)("Could not found database password for db." + dsName + ".password"));
        this.dialect = DialectFactory.get(prop.get("db." + dsName + ".dialect", "mysql"));
        this.driverClass = prop.get("db." + dsName + ".driver", this.dialect.driverClass());
        this.showSql = prop.getBoolean("db." + dsName + ".showSql", Boolean.valueOf(false));
        this.maxStatements = prop.getInt("c3p0." + dsName + ".maxStatements", Integer.valueOf(C3P0Defaults.maxStatements()));
        this.maxStatementsPerConnection = prop.getInt("c3p0." + dsName + ".maxStatementsPerConnection", Integer.valueOf(C3P0Defaults.maxStatementsPerConnection()));
        this.initialPoolSize = prop.getInt("c3p0." + dsName + ".initialPoolSize", Integer.valueOf(C3P0Defaults.initialPoolSize()));
        this.minPoolSize = prop.getInt("c3p0." + dsName + ".minPoolSize", Integer.valueOf(C3P0Defaults.minPoolSize()));
        this.maxPoolSize = prop.getInt("c3p0." + dsName + ".maxPoolSize", Integer.valueOf(C3P0Defaults.maxPoolSize()));
        this.idleConnectionTestPeriod = prop.getInt("c3p0." + dsName + ".idleConnectionTestPeriod", Integer.valueOf(C3P0Defaults.idleConnectionTestPeriod()));
        this.maxIdleTime = prop.getInt("c3p0." + dsName + ".minEvictableIdleTimeMillis", Integer.valueOf(C3P0Defaults.maxIdleTime()));
        this.propertyCycle = prop.getInt("c3p0." + dsName + ".propertyCycle", Integer.valueOf(C3P0Defaults.propertyCycle()));
        this.acquireIncrement = prop.getInt("c3p0." + dsName + ".acquireIncrement", Integer.valueOf(C3P0Defaults.acquireIncrement()));
        this.acquireRetryAttempts = prop.getInt("c3p0." + dsName + ".acquireRetryAttempts", Integer.valueOf(C3P0Defaults.acquireRetryAttempts()));
        this.acquireRetryDelay = prop.getInt("c3p0." + dsName + ".acquireRetryDelay", Integer.valueOf(C3P0Defaults.acquireRetryDelay()));
        this.checkoutTimeout = prop.getInt("c3p0." + dsName + ".checkoutTimeout", Integer.valueOf(C3P0Defaults.checkoutTimeout()));
        this.maxAdministrativeTaskTime = prop.getInt("c3p0." + dsName + ".maxAdministrativeTaskTime", Integer.valueOf(C3P0Defaults.maxAdministrativeTaskTime()));
        this.maxIdleTimeExcessConnections = prop.getInt("c3p0." + dsName + ".maxIdleTimeExcessConnections", Integer.valueOf(C3P0Defaults.maxIdleTimeExcessConnections()));
        this.maxConnectionAge = prop.getInt("c3p0." + dsName + ".maxConnectionAge", Integer.valueOf(C3P0Defaults.maxConnectionAge()));
        this.unreturnedConnectionTimeout = prop.getInt("c3p0." + dsName + ".unreturnedConnectionTimeout", Integer.valueOf(C3P0Defaults.unreturnedConnectionTimeout()));
        this.breakAfterAcquireFailure = prop.getBoolean("c3p0." + dsName + ".breakAfterAcquireFailure", Boolean.valueOf(C3P0Defaults.breakAfterAcquireFailure()));
        this.testConnectionOnCheckout = prop.getBoolean("c3p0." + dsName + ".testConnectionOnCheckout", Boolean.valueOf(C3P0Defaults.testConnectionOnCheckout()));
        this.testConnectionOnCheckin = prop.getBoolean("c3p0." + dsName + ".breakAfterAcquireFailure", Boolean.valueOf(C3P0Defaults.testConnectionOnCheckin()));
        this.autoCommitOnClose = prop.getBoolean("c3p0." + dsName + ".breakAfterAcquireFailure", Boolean.valueOf(C3P0Defaults.autoCommitOnClose()));
        this.automaticTestTable = prop.get("c3p0." + dsName + ".testOnBorrow", C3P0Defaults.automaticTestTable());
        this.preferredTestQuery = prop.get("c3p0." + dsName + ".preferredTestQuery", this.dialect.validQuery());
        this.buidDataSource();
    }

    public C3p0DataSourceProvider(String url, String user, String password) {
        this(url, user, password, null);
    }

    public C3p0DataSourceProvider(String url, String user, String password, boolean showSql) {
        this(url, user, password, null, showSql);
    }

    public C3p0DataSourceProvider(String url, String user, String password, String dbType) {
        this(url, user, password, dbType, null);
    }

    public C3p0DataSourceProvider(String url, String user, String password, String dbType, boolean showSql) {
        this(url, user, password, dbType, null, showSql);
    }

    public C3p0DataSourceProvider(String url, String user, String password, String dbType, String driverClass) {
        this(url, user, password, dbType, driverClass, false);
    }

    public C3p0DataSourceProvider(String url, String user, String password, String dbType, String driverClass, boolean showSql) {
        this.url = url;
        Checker.checkNotNull((Object)this.url, (Object)"Could not found database url for custom.");
        this.user = user;
        Checker.checkNotNull((Object)this.user, (Object)"Could not found database user for custom.");
        this.password = password;
        Checker.checkNotNull((Object)this.password, (Object)"Could not found database password for custom.");
        this.dialect = DialectFactory.get(dbType);
        this.driverClass = driverClass == null ? this.dialect.driverClass() : driverClass;
        this.showSql = showSql;
        this.buidDataSource();
    }

    private void buidDataSource() {
        this.ds = new ComboPooledDataSource();
        this.ds.setJdbcUrl(this.url);
        this.ds.setUser(this.user);
        this.ds.setPassword(this.password);
        try {
            this.ds.setDriverClass(this.driverClass);
        }
        catch (PropertyVetoException e) {
            this.ds = null;
            throw new DBException("ComboPooledDataSource set driverClass error.");
        }
        this.ds.setMaxStatements(this.maxStatements);
        this.ds.setMaxStatementsPerConnection(this.maxStatementsPerConnection);
        this.ds.setInitialPoolSize(this.initialPoolSize);
        this.ds.setMinPoolSize(this.minPoolSize);
        this.ds.setMaxPoolSize(this.maxPoolSize);
        this.ds.setIdleConnectionTestPeriod(this.idleConnectionTestPeriod);
        this.ds.setMaxIdleTime(this.maxIdleTime);
        this.ds.setPropertyCycle(this.propertyCycle);
        this.ds.setAcquireIncrement(this.acquireIncrement);
        this.ds.setAcquireRetryAttempts(this.acquireRetryAttempts);
        this.ds.setAcquireRetryDelay(this.acquireRetryDelay);
        this.ds.setCheckoutTimeout(this.checkoutTimeout);
        this.ds.setMaxAdministrativeTaskTime(this.maxAdministrativeTaskTime);
        this.ds.setMaxIdleTimeExcessConnections(this.maxIdleTimeExcessConnections);
        this.ds.setMaxConnectionAge(this.maxConnectionAge);
        this.ds.setUnreturnedConnectionTimeout(this.unreturnedConnectionTimeout);
        this.ds.setBreakAfterAcquireFailure(this.breakAfterAcquireFailure);
        this.ds.setTestConnectionOnCheckout(this.testConnectionOnCheckout);
        this.ds.setTestConnectionOnCheckin(this.testConnectionOnCheckin);
        this.ds.setAutoCommitOnClose(this.autoCommitOnClose);
        this.ds.setAutomaticTestTable(this.automaticTestTable);
        this.ds.setPreferredTestQuery(this.preferredTestQuery);
    }

    @Override
    public DataSource getDataSource() {
        return this.ds;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public String getDsName() {
        return this.dsName;
    }

    @Override
    public boolean isShowSql() {
        return this.showSql;
    }

    public C3p0DataSourceProvider setShowSql(boolean showSql) {
        this.showSql = showSql;
        return this;
    }

    @Override
    public void close() {
        try {
            this.ds.close();
            DataSources.destroy((DataSource)this.ds);
        }
        catch (SQLException e) {
            throw new DBException("ComboPooledDataSource close error.");
        }
    }

    public C3p0DataSourceProvider setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        try {
            this.ds.setDriverClass(driverClass);
        }
        catch (PropertyVetoException e) {
            this.ds = null;
            throw new DBException("ComboPooledDataSource set driverClass error.");
        }
        return this;
    }

    public C3p0DataSourceProvider setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
        this.ds.setMaxStatements(maxStatements);
        return this;
    }

    public C3p0DataSourceProvider setMaxStatementsPerConnection(int maxStatementsPerConnection) {
        this.maxStatementsPerConnection = maxStatementsPerConnection;
        this.ds.setMaxStatementsPerConnection(maxStatementsPerConnection);
        return this;
    }

    public C3p0DataSourceProvider setInitialPoolSize(int initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
        this.ds.setInitialPoolSize(initialPoolSize);
        return this;
    }

    public C3p0DataSourceProvider setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
        this.ds.setMinPoolSize(minPoolSize);
        return this;
    }

    public C3p0DataSourceProvider setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        this.ds.setMaxPoolSize(maxPoolSize);
        return this;
    }

    public C3p0DataSourceProvider setIdleConnectionTestPeriod(int idleConnectionTestPeriod) {
        this.idleConnectionTestPeriod = idleConnectionTestPeriod;
        this.ds.setIdleConnectionTestPeriod(idleConnectionTestPeriod);
        return this;
    }

    public C3p0DataSourceProvider setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
        this.ds.setMaxIdleTime(maxIdleTime);
        return this;
    }

    public C3p0DataSourceProvider setPropertyCycle(int propertyCycle) {
        this.propertyCycle = propertyCycle;
        this.ds.setPropertyCycle(propertyCycle);
        return this;
    }

    public C3p0DataSourceProvider setAcquireIncrement(int acquireIncrement) {
        this.acquireIncrement = acquireIncrement;
        this.ds.setAcquireIncrement(acquireIncrement);
        return this;
    }

    public C3p0DataSourceProvider setAcquireRetryAttempts(int acquireRetryAttempts) {
        this.acquireRetryAttempts = acquireRetryAttempts;
        this.ds.setAcquireRetryAttempts(acquireRetryAttempts);
        return this;
    }

    public C3p0DataSourceProvider setAcquireRetryDelay(int acquireRetryDelay) {
        this.acquireRetryDelay = acquireRetryDelay;
        this.ds.setAcquireRetryDelay(acquireRetryDelay);
        return this;
    }

    public C3p0DataSourceProvider setCheckoutTimeout(int checkoutTimeout) {
        this.checkoutTimeout = checkoutTimeout;
        this.ds.setCheckoutTimeout(checkoutTimeout);
        return this;
    }

    public C3p0DataSourceProvider setMaxAdministrativeTaskTime(int maxAdministrativeTaskTime) {
        this.maxAdministrativeTaskTime = maxAdministrativeTaskTime;
        this.ds.setMaxAdministrativeTaskTime(maxAdministrativeTaskTime);
        return this;
    }

    public C3p0DataSourceProvider setMaxIdleTimeExcessConnections(int maxIdleTimeExcessConnections) {
        this.maxIdleTimeExcessConnections = maxIdleTimeExcessConnections;
        this.ds.setMaxIdleTimeExcessConnections(maxIdleTimeExcessConnections);
        return this;
    }

    public C3p0DataSourceProvider setMaxConnectionAge(int maxConnectionAge) {
        this.maxConnectionAge = maxConnectionAge;
        this.ds.setMaxConnectionAge(maxConnectionAge);
        return this;
    }

    public C3p0DataSourceProvider setUnreturnedConnectionTimeout(int unreturnedConnectionTimeout) {
        this.unreturnedConnectionTimeout = unreturnedConnectionTimeout;
        this.ds.setUnreturnedConnectionTimeout(unreturnedConnectionTimeout);
        return this;
    }

    public C3p0DataSourceProvider setBreakAfterAcquireFailure(boolean breakAfterAcquireFailure) {
        this.breakAfterAcquireFailure = breakAfterAcquireFailure;
        this.ds.setBreakAfterAcquireFailure(breakAfterAcquireFailure);
        return this;
    }

    public C3p0DataSourceProvider setTestConnectionOnCheckout(boolean testConnectionOnCheckout) {
        this.testConnectionOnCheckout = testConnectionOnCheckout;
        this.ds.setTestConnectionOnCheckout(testConnectionOnCheckout);
        return this;
    }

    public C3p0DataSourceProvider setTestConnectionOnCheckin(boolean testConnectionOnCheckin) {
        this.testConnectionOnCheckin = testConnectionOnCheckin;
        this.ds.setTestConnectionOnCheckin(testConnectionOnCheckin);
        return this;
    }

    public C3p0DataSourceProvider setAutoCommitOnClose(boolean autoCommitOnClose) {
        this.autoCommitOnClose = autoCommitOnClose;
        this.ds.setAutoCommitOnClose(autoCommitOnClose);
        return this;
    }

    public C3p0DataSourceProvider setAutomaticTestTable(String automaticTestTable) {
        this.automaticTestTable = automaticTestTable;
        this.ds.setAutomaticTestTable(automaticTestTable);
        return this;
    }
}

