/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm.generate;

import cn.dreampie.orm.generate.Generator;
import cn.dreampie.orm.generate.UUIDGenerator;
import java.util.HashMap;
import java.util.Map;

public class GeneratorFactory {
    public static final String UUID = "uuid";
    private static Map<String, Generator> generatorMap = new HashMap<String, Generator>(){
        {
            this.put(GeneratorFactory.UUID, new UUIDGenerator());
        }
    };

    public static void add(String type, Generator generator) {
        if (!(generator instanceof UUIDGenerator)) {
            generatorMap.put(type, generator);
        }
    }

    public static Generator get(String type) {
        Generator generator = generatorMap.get(type);
        if (generator == null && !type.isEmpty()) {
            throw new IllegalArgumentException("Could not found generator for type: " + type);
        }
        return generator;
    }

    public static boolean contains(String type) {
        return generatorMap.containsKey(type);
    }
}

