/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm.dialect;

import cn.dreampie.orm.dialect.DefaultDialect;

public class PostgreSQLDialect
extends DefaultDialect {
    @Override
    public String getDbType() {
        return "postgreSQL";
    }

    @Override
    public String validQuery() {
        return "SELECT VERSION();";
    }

    @Override
    public String driverClass() {
        return "org.postgresql.Driver";
    }

    @Override
    public String paginateWith(int pageNumber, int pageSize, String sql) {
        if (pageNumber == 1 && pageSize == 1 && this.selectSinglePattern.matcher(sql).find()) {
            return sql;
        }
        int offset = pageSize * (pageNumber - 1);
        return sql + " LIMIT " + pageSize + " OFFSET " + offset;
    }
}

