/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm.dialect;

import cn.dreampie.orm.dialect.DefaultDialect;

public class OracleDialect
extends DefaultDialect {
    @Override
    public String getDbType() {
        return "oracle";
    }

    @Override
    public String validQuery() {
        return "SELECT 1 FROM dual";
    }

    @Override
    public String driverClass() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    public String paginateWith(int pageNumber, int pageSize, String sql) {
        if (pageNumber == 1 && pageSize == 1 && this.selectSinglePattern.matcher(sql).find()) {
            return sql;
        }
        int start = (pageNumber - 1) * pageSize + 1;
        int end = pageNumber * pageSize;
        return "SELECT * FROM ( SELECT row_.*, ROWNUM rownum_ FROM (  " + sql + " ) row_ WHERE ROWNUM <= " + end + ") paginate_alias" + " WHERE paginate_alias.rownum_ >= " + start;
    }
}

