/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm.dialect;

import cn.dreampie.orm.dialect.DefaultDialect;
import java.util.regex.Matcher;

public class MSSQLDialect
extends DefaultDialect {
    @Override
    public String getDbType() {
        return "mssql";
    }

    @Override
    public String validQuery() {
        return "SELECT 1";
    }

    @Override
    public String driverClass() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    public String paginateWith(int pageNumber, int pageSize, String sql) {
        int oindex;
        if (pageNumber == 1 && pageSize == 1 && this.selectSinglePattern.matcher(sql).find()) {
            return sql;
        }
        int offset = pageSize * (pageNumber - 1);
        String orderBys = null;
        Matcher om = this.orderPattern.matcher(sql);
        if (om.find() && (oindex = om.end()) > sql.lastIndexOf(")")) {
            orderBys = sql.substring(oindex, sql.length());
            sql = sql.substring(0, om.start());
        }
        if (orderBys == null) {
            orderBys = "CURRENT_TIMESTAMP";
        }
        StringBuilder querySql = new StringBuilder();
        querySql.append("SELECT paginate_alias.* FROM (SELECT ROW_NUMBER() OVER (ORDER BY ");
        querySql.append(orderBys);
        querySql.append(") rownumber,");
        Matcher sm = this.selectPattern.matcher(sql);
        if (sm.find()) {
            querySql.append(' ').append(sql.substring(sm.end()));
        } else {
            querySql.append(sql);
        }
        querySql.append(") paginate_alias WHERE rownumber BETWEEN ").append(offset + 1).append(" AND ").append(pageSize + offset);
        return querySql.toString();
    }
}

