/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm.dialect;

import cn.dreampie.orm.dialect.Dialect;
import cn.dreampie.orm.dialect.H2Dialect;
import cn.dreampie.orm.dialect.MSSQLDialect;
import cn.dreampie.orm.dialect.MySQLDialect;
import cn.dreampie.orm.dialect.OracleDialect;
import cn.dreampie.orm.dialect.PostgreSQLDialect;
import cn.dreampie.orm.dialect.SQLiteDialect;
import cn.dreampie.orm.exception.DBException;
import java.util.HashMap;
import java.util.Map;

public class DialectFactory {
    private static Map<String, Dialect> dialectMap = new HashMap<String, Dialect>(){
        {
            this.put("h2", new H2Dialect());
            this.put("mssql", new MSSQLDialect());
            this.put("mysql", new MySQLDialect());
            this.put("oracle", new OracleDialect());
            this.put("postgreSQL", new PostgreSQLDialect());
            this.put("sqlite", new SQLiteDialect());
        }
    };

    public static Map<String, Dialect> getDialectMap() {
        return dialectMap;
    }

    public static void setDialectMap(Map<String, Dialect> dialectMap) {
        DialectFactory.dialectMap = dialectMap;
    }

    public static Dialect get(String dialectName) {
        Dialect dialect = dialectMap.get(dialectName);
        if (dialect == null) {
            throw new DBException("Dialect could not found for name " + dialectName + ".only support like this:" + dialectMap.keySet().toString());
        }
        return dialect;
    }

    public static void addDialectMap(Map<String, Dialect> dialectMap) {
        DialectFactory.dialectMap.putAll(dialectMap);
    }

    public static void addDialect(String dialectName, Dialect dialect) {
        dialectMap.put(dialectName, dialect);
    }
}

