/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm.dialect;

import cn.dreampie.common.util.Joiner;
import cn.dreampie.orm.dialect.Dialect;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DefaultDialect
implements Dialect {
    private static Map<Integer, Class> typeMappings = new HashMap<Integer, Class>(){
        {
            this.put(4, Integer.class);
            this.put(5, Integer.class);
            this.put(-5, Long.class);
            this.put(6, Float.class);
            this.put(8, Double.class);
            this.put(3, BigDecimal.class);
        }
    };
    protected final Pattern selectPattern = Pattern.compile("^\\s*SELECT\\s+", 2);
    protected final Pattern orderPattern = Pattern.compile("\\s+ORDER\\s+BY\\s+", 10);
    protected final Pattern groupPattern = Pattern.compile("\\s+GROUP\\s+BY\\s+", 10);
    protected final Pattern havingPattern = Pattern.compile("\\s+HAVING\\s+", 10);
    protected final Pattern selectSinglePattern = Pattern.compile("^\\s*SELECT\\s+((COUNT)\\([\\s\\S]*\\)\\s*,?)+((\\s*)|(\\s+FROM[\\s\\S]*))?$", 2);

    @Override
    public Class getColumnType(int type) {
        return typeMappings.get(type);
    }

    protected String getAlias(String alias) {
        alias = null != alias && !"".equals(alias.trim()) ? " " + alias : "";
        return alias;
    }

    protected String[] getPrefix(String alias, String ... columns) {
        if (null != alias && !"".equals(alias.trim()) && columns.length > 0) {
            String[] newColumns = new String[columns.length];
            int i = 0;
            for (String column : columns) {
                if (column.contains(".")) {
                    return columns;
                }
                newColumns[i] = alias + "." + column;
                ++i;
            }
            return newColumns;
        }
        return columns;
    }

    public String getWhere(String where) {
        Matcher om;
        if (!where.startsWith(" ")) {
            where = " " + where;
        }
        if ((om = this.orderPattern.matcher(where)).find() && om.start() == 0) {
            return where;
        }
        Matcher gm = this.groupPattern.matcher(where);
        if (gm.find() && gm.start() == 0) {
            return where;
        }
        Matcher hm = this.havingPattern.matcher(where);
        if (hm.find() && hm.start() == 0) {
            return where;
        }
        return " WHERE" + where;
    }

    @Override
    public String select(String table) {
        return "SELECT * FROM " + table;
    }

    @Override
    public String select(String table, String ... columns) {
        if (columns == null || columns.length <= 0) {
            return this.select(table);
        }
        return "SELECT " + Joiner.on((String)", ").join((Object[])columns) + " FROM " + table;
    }

    @Override
    public String select(String table, String alias, String where) {
        if (where == null || "".equals(where.trim())) {
            return this.select(table);
        }
        return "SELECT * FROM " + table + this.getAlias(alias) + this.getWhere(where);
    }

    @Override
    public String select(String table, String alias, String where, String ... columns) {
        if (where == null || "".equals(where.trim())) {
            return this.select(table, columns);
        }
        if (columns == null || columns.length <= 0) {
            return this.select(table, alias, where);
        }
        return "SELECT " + Joiner.on((String)", ").join((Object[])this.getPrefix(alias, columns)) + " FROM " + table + this.getAlias(alias) + this.getWhere(where);
    }

    protected void appendQuestions(StringBuilder sql, int count) {
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                sql.append("?");
                continue;
            }
            sql.append(",?");
        }
    }

    @Override
    public String insert(String table, String ... columns) {
        return this.insert(table, (String)null, (String)null, columns);
    }

    @Override
    public String insert(String table, String id, String sequence, String ... columns) {
        boolean inSequence;
        StringBuilder sql = new StringBuilder().append("INSERT INTO ").append(table).append(" (");
        boolean bl = inSequence = id != null && !id.isEmpty() && sequence != null && !sequence.isEmpty();
        if (inSequence) {
            sql.append(id).append(",");
        }
        sql.append(Joiner.on((String)", ").join((Object[])columns));
        sql.append(") VALUES (");
        if (inSequence) {
            sql.append(sequence).append(",");
        }
        this.appendQuestions(sql, columns.length);
        sql.append(')');
        return sql.toString();
    }

    @Override
    public String delete(String table) {
        return "DELETE FROM " + table;
    }

    @Override
    public String delete(String table, String where) {
        if (where == null || "".equals(where.trim())) {
            return this.delete(table);
        }
        return "DELETE FROM " + table + this.getWhere(where);
    }

    @Override
    public String update(String table, String ... columns) {
        if (columns == null || columns.length <= 0) {
            throw new NullPointerException("Could not found columns to update.");
        }
        return "UPDATE " + table + " SET " + Joiner.on((String)"=?, ").join((Object[])columns) + "=?";
    }

    @Override
    public String update(String table, String alias, String where, String ... columns) {
        if (where == null || "".equals(where.trim())) {
            return this.update(table, columns);
        }
        if (columns == null || columns.length <= 0) {
            throw new NullPointerException("Could not found columns to update.");
        }
        return "UPDATE " + table + this.getAlias(alias) + " SET " + Joiner.on((String)"=?, ").join((Object[])this.getPrefix(alias, columns)) + "=?" + this.getWhere(where);
    }

    @Override
    public String count(String table) {
        return "SELECT COUNT(*) FROM " + table;
    }

    @Override
    public String count(String table, String alias, String where) {
        if (where == null || "".equals(where.trim())) {
            return this.count(table);
        }
        return "SELECT COUNT(*) FROM " + table + this.getAlias(alias) + this.getWhere(where);
    }

    @Override
    public String countWith(String sql) {
        int index;
        Matcher om = this.orderPattern.matcher(sql);
        if (om.find() && (index = om.end()) > sql.lastIndexOf(")")) {
            sql = sql.substring(0, om.start());
        }
        return "SELECT COUNT(*) FROM (" + sql + ") count_alias";
    }

    @Override
    public String paginate(int pageNumber, int pageSize, String table) {
        return this.paginateWith(pageNumber, pageSize, this.select(table));
    }

    @Override
    public String paginate(int pageNumber, int pageSize, String table, String ... columns) {
        return this.paginateWith(pageNumber, pageSize, this.select(table, columns));
    }

    @Override
    public String paginate(int pageNumber, int pageSize, String table, String alias, String where) {
        return this.paginateWith(pageNumber, pageSize, this.select(table, alias, where));
    }

    @Override
    public String paginate(int pageNumber, int pageSize, String table, String alias, String where, String ... columns) {
        return this.paginateWith(pageNumber, pageSize, this.select(table, alias, where, columns));
    }
}

