/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm.cache;

import cn.dreampie.cache.CacheEvent;
import cn.dreampie.cache.CacheProvider;
import cn.dreampie.common.Constant;
import cn.dreampie.common.util.Joiner;
import cn.dreampie.log.Logger;
import java.util.Arrays;

public enum QueryCache {
    INSTANCE;

    public static final String QUERY_DEF_KEY = "_query";
    private static final Logger logger;
    private final boolean enabled = Constant.cacheEnabled;
    private final CacheProvider cacheProvider = CacheProvider.INSTANCE;

    public static QueryCache instance() {
        return INSTANCE;
    }

    static void logAccess(String group, String query, Object[] params, String access) {
        if (logger.isDebugEnabled()) {
            StringBuilder log = new StringBuilder().append(access).append(", group: {").append(group).append("}, query: {").append(query).append("} ");
            if (params != null && params.length > 0) {
                log.append(", params: ").append('{');
                log.append(Joiner.on((String)"}, {").useForNull("null").join(params));
                log.append('}');
            }
            logger.debug(log.toString());
        }
    }

    public void add(String dsmName, String tableName, String type, String query, Object[] params, Object cache) {
        this.add(dsmName, tableName, type, query, params, cache, -1);
    }

    public void add(String dsmName, String tableName, String type, String query, Object[] params, Object cache, int expired) {
        if (this.enabled) {
            String group = this.getGroup(dsmName, tableName);
            this.cacheProvider.addCache(group, this.getKey(type, query, params), cache, expired);
        }
    }

    private String getGroup(String dsmName, String tableName) {
        return "_query::" + dsmName + "::" + tableName;
    }

    public <T> T get(String dsmName, String tableName, String type, String query, Object[] params) {
        if (this.enabled) {
            String key;
            String group = this.getGroup(dsmName, tableName);
            Object item = this.cacheProvider.getCache(group, key = this.getKey(type, query, params));
            if (item == null) {
                QueryCache.logAccess(group, query, params, "Miss");
            } else {
                QueryCache.logAccess(group, query, params, "Hit");
                return (T)item;
            }
        }
        return null;
    }

    private String getKey(String type, String query, Object[] params) {
        return type + "::" + query + "::" + (params == null ? null : Arrays.asList(params).toString());
    }

    public void remove(String dsmName, String tableName, String type, String query, Object[] params) {
        if (this.enabled) {
            String group = this.getGroup(dsmName, tableName);
            this.cacheProvider.removeCache(group, this.getKey(type, query, params));
        }
    }

    public void purge(String dsmName, String tableName) {
        if (this.enabled) {
            this.cacheProvider.flush(new CacheEvent(this.getGroup(dsmName, tableName), ((Object)((Object)this)).getClass().getName()));
        }
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    static {
        logger = Logger.getLogger(QueryCache.class);
    }
}

