/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm.aspect;

import cn.dreampie.log.Logger;
import cn.dreampie.orm.aspect.Aspect;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class AspectHandler
implements InvocationHandler {
    private static final Logger logger = Logger.getLogger(AspectHandler.class);
    private Object target = null;
    private Aspect[] aspects = null;
    private int index = -1;

    public AspectHandler(int index, Object target, Aspect[] aspects) {
        this.index = index;
        this.target = target;
        this.aspects = aspects;
    }

    public AspectHandler(Object target, Aspect[] aspects) {
        this.target = target;
        this.aspects = aspects;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Aspect[] getAspects() {
        return this.aspects;
    }

    public void setAspects(Aspect ... aspects) {
        this.aspects = aspects;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.index == -1) {
            logger.info("Instance an AspectHandler to invoke method %s.", new Object[]{method.getName()});
            return new AspectHandler(0, this.target, this.aspects).invoke(proxy, method, args);
        }
        Object result = null;
        if (this.index < this.aspects.length) {
            result = this.aspects[this.index++].aspect(this, proxy, method, args);
        } else if (this.index++ == this.aspects.length) {
            result = method.invoke(this.target, args);
        }
        return result;
    }
}

