/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm;

import cn.dreampie.log.Logger;
import cn.dreampie.orm.DataSourceMeta;
import cn.dreampie.orm.exception.TransactionException;
import java.sql.Connection;
import java.sql.SQLException;

public class TransactionManager {
    private static final Logger logger = Logger.getLogger(TransactionManager.class);
    private DataSourceMeta dataSourceMeta;
    private boolean begined;
    private int level;
    private Boolean readonly;
    private Boolean autoCommit;

    public TransactionManager(DataSourceMeta dataSourceMeta, boolean readonly, int level) {
        this.dataSourceMeta = dataSourceMeta;
        this.readonly = readonly;
        this.level = level;
    }

    public boolean isBegined() {
        return this.begined;
    }

    public void begin() throws TransactionException {
        Connection conn = this.dataSourceMeta.getCurrentConnection();
        try {
            if (this.readonly == null || !this.readonly.booleanValue()) {
                if (conn == null) {
                    conn = this.dataSourceMeta.getWriteConnection();
                    this.dataSourceMeta.setCurrentConnection(conn);
                }
                this.autoCommit = conn.getAutoCommit();
                if (conn.getAutoCommit()) {
                    conn.setAutoCommit(false);
                }
                logger.info("Connection for " + this.dataSourceMeta.getWriteDsName() + " has opened success.");
            } else {
                if (conn == null) {
                    conn = this.dataSourceMeta.getReadConnection();
                    this.dataSourceMeta.setCurrentConnection(conn);
                }
                this.readonly = conn.isReadOnly();
                conn.setReadOnly(true);
                logger.info("Connection for " + this.dataSourceMeta.getReadDsName() + " has opened success.");
            }
            conn.setTransactionIsolation(this.level);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage(), e);
        }
        finally {
            this.begined = true;
        }
    }

    public void commit() throws TransactionException {
        Connection conn = this.dataSourceMeta.getCurrentConnection();
        try {
            if (!(conn == null || this.readonly != null && this.readonly.booleanValue() || conn.getAutoCommit())) {
                conn.commit();
                logger.info("Connection for " + this.dataSourceMeta.getWriteDsName() + " has commited success.");
            }
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage(), e);
        }
    }

    public void end() {
        Connection conn = this.dataSourceMeta.getCurrentConnection();
        try {
            if (conn != null) {
                if (this.autoCommit != null) {
                    conn.setAutoCommit(this.autoCommit);
                    this.autoCommit = null;
                }
                if (this.readonly != null) {
                    conn.setReadOnly(this.readonly);
                    this.readonly = null;
                }
                this.dataSourceMeta.rmCurrentConnection();
                this.dataSourceMeta.close(conn);
                if (this.readonly == null || !this.readonly.booleanValue()) {
                    logger.info("Connection for " + this.dataSourceMeta.getWriteDsName() + " has closed success.");
                } else {
                    logger.info("Connection for " + this.dataSourceMeta.getReadDsName() + " has closed success.");
                }
            }
        }
        catch (SQLException e) {
            if (this.readonly == null || !this.readonly.booleanValue()) {
                logger.error("Could not end connection for " + this.dataSourceMeta.getWriteDsName() + ".", (Throwable)e);
            }
            logger.error("Could not end connection for " + this.dataSourceMeta.getReadDsName() + ".", (Throwable)e);
        }
    }

    public void rollback() {
        Connection conn = this.dataSourceMeta.getCurrentConnection();
        try {
            if (!(conn == null || this.readonly != null && this.readonly.booleanValue())) {
                conn.rollback();
                logger.info("Connection for " + this.dataSourceMeta.getWriteDsName() + " has rollbacked success.");
            }
        }
        catch (SQLException e) {
            logger.error("Could not rollback connection for " + this.dataSourceMeta.getWriteDsName() + ".", (Throwable)e);
        }
    }
}

