/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm;

import cn.dreampie.common.entity.CaseInsensitiveMap;
import cn.dreampie.log.Logger;
import cn.dreampie.orm.ColumnMeta;
import cn.dreampie.orm.DataSourceMeta;
import cn.dreampie.orm.Metadata;
import cn.dreampie.orm.TableMeta;
import cn.dreampie.orm.exception.DBException;
import java.net.ConnectException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;

public class TableMetaBuilder {
    private static final Logger logger = Logger.getLogger(TableMetaBuilder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<TableMeta> buildTableMeta(Set<TableMeta> tableMetas, DataSourceMeta dsm) {
        TableMeta temp = null;
        Connection conn = null;
        try {
            conn = dsm.getReadConnection();
            Iterator<TableMeta> i$ = tableMetas.iterator();
            while (i$.hasNext()) {
                TableMeta tableMeta;
                temp = tableMeta = i$.next();
                SortedMap<String, ColumnMeta> columns = TableMetaBuilder.fetchMetaColumns(conn.getMetaData(), conn.getMetaData().getDatabaseProductName(), tableMeta.getTableName());
                if (columns == null || columns.size() <= 0) continue;
                temp.setColumnMetadata(columns);
                Metadata.addTableMeta(temp);
            }
        }
        catch (Exception e) {
            TableMetaBuilder.logAcess(dsm, temp, e);
        }
        finally {
            dsm.close(conn);
        }
        return tableMetas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableMeta buildTableMeta(TableMeta tableMeta, DataSourceMeta dsm) {
        Connection conn = null;
        try {
            conn = dsm.getReadConnection();
            SortedMap<String, ColumnMeta> columns = TableMetaBuilder.fetchMetaColumns(conn.getMetaData(), conn.getMetaData().getDatabaseProductName(), tableMeta.getTableName());
            if (columns != null && columns.size() > 0) {
                tableMeta.setColumnMetadata(columns);
                Metadata.addTableMeta(tableMeta);
            }
        }
        catch (Exception e) {
            TableMetaBuilder.logAcess(dsm, tableMeta, e);
        }
        finally {
            dsm.close(conn);
        }
        return tableMeta;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SortedMap<String, ColumnMeta> fetchMetaColumns(DatabaseMetaData databaseMetaData, String databaseProductName, String table) throws SQLException {
        String tableName;
        String schema = null;
        if (table.contains(".")) {
            String[] vals = table.split("\\.");
            if (vals.length == 1) {
                tableName = vals[0];
            } else {
                if (vals.length != 2) throw new DBException("Invalid table name: " + table);
                schema = vals[0];
                tableName = vals[1];
                if (schema.length() == 0 || tableName.length() == 0) {
                    throw new DBException("Invalid table name : " + table);
                }
            }
        } else {
            tableName = table;
        }
        ResultSet rs = databaseMetaData.getColumns(null, schema, tableName, null);
        String dbProduct = databaseMetaData.getDatabaseProductName().toLowerCase();
        SortedMap<String, ColumnMeta> columns = TableMetaBuilder.getColumns(rs, dbProduct);
        rs.close();
        if (columns.isEmpty()) {
            rs = databaseMetaData.getColumns(null, schema, tableName.toUpperCase(), null);
            dbProduct = databaseProductName.toLowerCase();
            columns = TableMetaBuilder.getColumns(rs, dbProduct);
            rs.close();
        }
        if (columns.isEmpty()) {
            rs = databaseMetaData.getColumns(null, schema, tableName.toLowerCase(), null);
            columns = TableMetaBuilder.getColumns(rs, dbProduct);
            rs.close();
        }
        if (columns.size() > 0) {
            logger.debug("Fetched metadata for table: %s", new Object[]{table});
            return columns;
        } else {
            logger.warn("Failed to retrieve metadata for table: '%s'. Are you sure this table exists? For some databases table name are case sensitive.", new Object[]{table});
        }
        return columns;
    }

    private static SortedMap<String, ColumnMeta> getColumns(ResultSet rs, String dbProduct) throws SQLException {
        CaseInsensitiveMap columns = new CaseInsensitiveMap();
        while (rs.next()) {
            if (dbProduct.equals("h2") && "INFORMATION_SCHEMA".equals(rs.getString("TABLE_SCHEMA"))) continue;
            ColumnMeta cm = new ColumnMeta(rs.getString("COLUMN_NAME"), rs.getString("TYPE_NAME"), rs.getInt("DATA_TYPE"), rs.getInt("COLUMN_SIZE"));
            columns.put(cm.getColumnName(), cm);
        }
        return columns;
    }

    private static void logAcess(DataSourceMeta dsm, TableMeta temp, Exception e) {
        Throwable throwable;
        String message = e.getMessage();
        if (e instanceof ConnectException) {
            message = "Could not connect dataSource for name '" + dsm.getDsmName() + "'";
        } else if (temp != null) {
            message = "Could not create table object, maybe the table " + temp.getTableName() + " is not exists.";
        }
        if (message == null && (throwable = e.getCause()) != null) {
            message = throwable.getMessage();
        }
        throw new DBException(message, e);
    }
}

