/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm;

import cn.dreampie.common.entity.Entity;
import cn.dreampie.common.util.Checker;
import cn.dreampie.orm.ColumnMeta;
import cn.dreampie.orm.Metadata;
import cn.dreampie.orm.Model;
import cn.dreampie.orm.TableSetting;
import cn.dreampie.orm.annotation.Table;
import cn.dreampie.orm.dialect.Dialect;
import cn.dreampie.orm.generate.Generator;
import cn.dreampie.orm.generate.GeneratorFactory;
import java.io.Serializable;
import java.util.Collections;
import java.util.SortedMap;

public class TableMeta
implements Serializable {
    private final String dsmName;
    private final String tableName;
    private final String generatedKey;
    private final String[] primaryKey;
    private final Generator generator;
    private final boolean cached;
    private final int expired;
    private final String sequence;
    private final Class<? extends Entity> modelClass;
    private SortedMap<String, ColumnMeta> columnMetadata;
    private TableSetting tableSetting;

    protected TableMeta(String dsmName) {
        this.dsmName = dsmName;
        this.tableName = null;
        this.generatedKey = "";
        this.primaryKey = new String[0];
        this.generator = null;
        this.cached = false;
        this.expired = -1;
        this.sequence = null;
        this.modelClass = null;
        this.tableSetting = null;
    }

    protected TableMeta(TableSetting tableSetting) {
        this(Metadata.getDefaultDsmName(), tableSetting);
    }

    protected TableMeta(String dsmName, TableSetting tableSetting) {
        this.dsmName = dsmName;
        this.tableName = tableSetting.getTableName();
        this.generatedKey = tableSetting.getGeneratedKey();
        this.primaryKey = tableSetting.getPrimaryKey();
        this.generator = tableSetting.getGenerator();
        this.cached = tableSetting.isCached();
        this.expired = tableSetting.getExpired();
        this.sequence = tableSetting.getSequence();
        this.modelClass = null;
        this.tableSetting = tableSetting;
    }

    protected TableMeta(String dsmName, Class<? extends Model> modelClass) {
        Table tableAnnotation = modelClass.getAnnotation(Table.class);
        Checker.checkNotNull((Object)tableAnnotation, (Object)"Could not found @Table Annotation.");
        this.dsmName = dsmName;
        this.tableName = tableAnnotation.name();
        this.generatedKey = tableAnnotation.generatedKey();
        this.primaryKey = tableAnnotation.primaryKey();
        this.generator = GeneratorFactory.get(tableAnnotation.generatedType());
        this.cached = tableAnnotation.cached();
        this.expired = tableAnnotation.expired();
        this.sequence = tableAnnotation.sequence();
        this.modelClass = modelClass;
        this.tableSetting = new TableSetting(this.tableName, this.generatedKey, this.primaryKey, this.generator, this.cached, this.expired, this.sequence);
    }

    public String getDsmName() {
        return this.dsmName;
    }

    public boolean isCached() {
        return this.cached;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public Class<? extends Entity> getModelClass() {
        return this.modelClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getExpired() {
        return this.expired;
    }

    protected boolean tableExists() {
        return this.columnMetadata != null && this.columnMetadata.isEmpty();
    }

    public String getGeneratedKey() {
        return this.generatedKey;
    }

    public String[] getPrimaryKey() {
        return this.primaryKey;
    }

    public String getDbType() {
        return Metadata.getDataSourceMeta(this.dsmName).getDialect().getDbType();
    }

    public Dialect getDialect() {
        return Metadata.getDataSourceMeta(this.dsmName).getDialect();
    }

    public String getSequence() {
        return this.sequence;
    }

    public TableSetting getTableSetting() {
        return this.tableSetting;
    }

    public SortedMap<String, ColumnMeta> getColumnMetadata() {
        Checker.checkNotNull(this.columnMetadata, (Object)("Failed to found table: " + this.getTableName()));
        return Collections.unmodifiableSortedMap(this.columnMetadata);
    }

    void setColumnMetadata(SortedMap<String, ColumnMeta> columnMetadata) {
        this.columnMetadata = columnMetadata;
    }

    public String getColumnTypeName(String columnName) {
        SortedMap<String, ColumnMeta> columnMetaSortedMap = this.getColumnMetadata();
        return ((ColumnMeta)columnMetaSortedMap.get(columnName)).getTypeName();
    }

    public boolean hasColumn(String column) {
        return this.columnMetadata != null && this.columnMetadata.containsKey(column);
    }

    public Integer getDataType(String column) {
        if (this.hasColumn(column)) {
            return ((ColumnMeta)this.columnMetadata.get(column)).getDataType();
        }
        return null;
    }

    public String toString() {
        StringBuilder t = new StringBuilder();
        t.append("TableMeta: ").append(this.tableName).append(", ").append(this.modelClass == null ? "Record" : this.modelClass).append("\n");
        if (this.columnMetadata != null) {
            for (String key : this.columnMetadata.keySet()) {
                t.append(this.columnMetadata.get(key)).append(", ");
            }
        }
        return t.toString();
    }
}

