/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm;

import cn.dreampie.common.util.Checker;
import cn.dreampie.orm.Base;
import cn.dreampie.orm.Metadata;
import cn.dreampie.orm.TableMeta;
import cn.dreampie.orm.TableMetaBuilder;
import cn.dreampie.orm.TableSetting;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;

public class Record
extends Base<Record> {
    private TableMeta tableMeta;
    private boolean useCache = true;

    public Record() {
        this.tableMeta = this.getTableMeta(null);
    }

    public Record(TableSetting tableSetting) {
        this.tableMeta = this.getTableMeta(null, tableSetting);
    }

    public Record(String dsmName, TableSetting tableSetting) {
        this.tableMeta = this.getTableMeta(dsmName, tableSetting);
    }

    public Record(TableMeta tableMeta) {
        this.tableMeta = tableMeta;
    }

    public Record reNew() {
        return new Record(this.tableMeta);
    }

    private Record instance(String dsmName, boolean useCache) {
        Record record = dsmName != null && !this.tableMeta.getDsmName().equals(dsmName) ? new Record(this.getTableMeta(dsmName, this.tableMeta.getTableSetting())) : new Record(this.tableMeta);
        record.useCache = useCache;
        return record;
    }

    @Override
    public boolean isUseCache() {
        return this.useCache;
    }

    @Override
    public Record unCache() {
        if (!this.useCache) {
            return this;
        }
        return this.instance(null, false);
    }

    @Override
    public Record useDSM(String dsmName) {
        Checker.checkNotNull((Object)dsmName, (Object)"DataSourceMetaName could not be null.");
        if (!this.useCache && !this.tableMeta.getDsmName().equals(dsmName)) {
            this.tableMeta = this.getTableMeta(dsmName, this.tableMeta.getTableSetting());
            return this;
        }
        if (this.tableMeta.getDsmName().equals(dsmName)) {
            return this;
        }
        return this.instance(dsmName, true);
    }

    @Override
    public TableMeta getTableMeta() {
        Checker.checkNotNull((Object)this.tableMeta, (Object)"Could not find tableMeta.");
        return this.tableMeta;
    }

    private TableMeta getTableMeta(String dsmName) {
        return this.getTableMeta(dsmName, null);
    }

    private TableMeta getTableMeta(String dsmName, TableSetting tableSetting) {
        if (dsmName == null) {
            dsmName = Metadata.getDefaultDsmName();
        }
        if (tableSetting == null) {
            return new TableMeta(dsmName);
        }
        String tableName = tableSetting.getTableName();
        Checker.checkNotNull((Object)dsmName, (Object)"Could not found dataSourceMeta.");
        Checker.checkNotNull((Object)tableName, (Object)"Could not found tableName.");
        if (Metadata.hasTableMeta(dsmName, tableName)) {
            return Metadata.getTableMeta(dsmName, tableName);
        }
        return TableMetaBuilder.buildTableMeta(new TableMeta(dsmName, tableSetting), Metadata.getDataSourceMeta(dsmName));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tableMeta = (TableMeta)in.readObject();
        this.putAttrs((Map)in.readObject());
        this.useCache = (Boolean)in.readObject();
        this.setAlias((String)in.readObject());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tableMeta);
        out.writeObject(this.getAttrs());
        out.writeObject(this.useCache);
        out.writeObject(this.getAlias());
    }
}

