/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm;

import cn.dreampie.common.entity.exception.EntityException;
import cn.dreampie.common.util.Checker;
import cn.dreampie.orm.Base;
import cn.dreampie.orm.Metadata;
import cn.dreampie.orm.TableMeta;
import cn.dreampie.orm.TableSetting;

public abstract class Model<M extends Model>
extends Base<M> {
    private boolean useCache = true;
    private String useDSM = null;

    @Override
    public boolean isUseCache() {
        return this.useCache;
    }

    private M instance(String useDSM, boolean useCache) {
        Model instance = null;
        try {
            instance = (Model)this.getMClass().newInstance();
            instance.useDSM = useDSM;
            instance.useCache = useCache;
            ((Model)instance.reSetAttrs(this.getAttrs())).reSetModifyAttrs(this.getModifyAttrs());
        }
        catch (InstantiationException e) {
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
        return (M)instance;
    }

    @Override
    public M unCache() {
        if (this.useDSM != null) {
            this.useCache = false;
            return (M)this;
        }
        if (!this.useCache) {
            return (M)this;
        }
        return this.instance(null, false);
    }

    @Override
    public M useDSM(String dsmName) {
        Checker.checkNotNull((Object)dsmName, (Object)"DataSourceMetaName could not be null.");
        if (!this.useCache) {
            this.useDSM = dsmName;
            return (M)this;
        }
        if (dsmName.equals(this.useDSM)) {
            return (M)this;
        }
        return this.instance(dsmName, true);
    }

    public boolean checkMethod() {
        return true;
    }

    @Override
    protected TableMeta getTableMeta() {
        TableMeta tableMeta = Metadata.getTableMeta(this.getMClass());
        if (this.useDSM != null) {
            String tableName = tableMeta.getTableName();
            tableMeta = Metadata.hasTableMeta(this.useDSM, tableName) ? Metadata.getTableMeta(this.useDSM, tableName) : Metadata.addTableMeta(new TableMeta(this.useDSM, new TableSetting(tableName, tableMeta.getGeneratedKey(), tableMeta.getPrimaryKey(), tableMeta.getGenerator(), tableMeta.isCached(), tableMeta.getExpired())));
        }
        Checker.checkNotNull((Object)tableMeta, (Object)"Could not find tableMeta.");
        return tableMeta;
    }
}

