/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm;

import cn.dreampie.common.entity.Entity;
import cn.dreampie.common.util.Checker;
import cn.dreampie.log.Logger;
import cn.dreampie.orm.DataSourceMeta;
import cn.dreampie.orm.TableMeta;
import java.util.HashMap;
import java.util.Map;

public class Metadata {
    private static final Logger logger = Logger.getLogger(Metadata.class);
    private static final String CONNECTOR = "@";
    private static String defaultDsmName;
    private static Map<String, DataSourceMeta> dataSourceMetaMap;
    private static Map<String, TableMeta> tableMetaMap;
    private static Map<Class<? extends Entity>, String> tableMetaClassMap;

    public static void close() {
        for (Map.Entry<String, DataSourceMeta> entry : dataSourceMetaMap.entrySet()) {
            entry.getValue().close();
        }
    }

    public static boolean hasDataSourceMeta(String dsmName) {
        return dataSourceMetaMap.containsKey(dsmName);
    }

    public static DataSourceMeta getDataSourceMeta(String dsmName) {
        DataSourceMeta dsm = dataSourceMetaMap.get(dsmName);
        Checker.checkNotNull((Object)dsm, (Object)("Could not found DataSourceMetadata for this dsmName:" + dsmName));
        return dsm;
    }

    public static boolean hasTableMeta(String dsmName, String tableName) {
        return tableMetaMap.containsKey(Metadata.getMark(dsmName, tableName));
    }

    public static boolean hasTableMeta(String mark) {
        return tableMetaMap.containsKey(mark);
    }

    public static TableMeta getTableMeta(String dsmName, String tableName) {
        return Metadata.getTableMeta(Metadata.getMark(dsmName, tableName));
    }

    public static TableMeta getTableMeta(Class<? extends Entity> clazz) {
        return Metadata.getTableMeta(tableMetaClassMap.get(clazz));
    }

    public static TableMeta getTableMeta(String mark) {
        TableMeta mm = tableMetaMap.get(mark);
        Checker.checkNotNull((Object)mm, (Object)("Could not found TableMetadata for this dsmName@tableName : " + mark));
        return mm;
    }

    public static String getTableMetaMark(Class<? extends Entity> clazz) {
        return tableMetaClassMap.get(clazz);
    }

    static DataSourceMeta addDataSourceMeta(DataSourceMeta dsm) {
        String dsmName = dsm.getDsmName();
        Checker.checkNotNull((Object)dsmName, (Object)"DataSourceMetaName could not be null.");
        if (dsmName.contains(CONNECTOR)) {
            throw new IllegalArgumentException("DataSourceMetaName not support '@' for name '" + dsmName + "'.");
        }
        if (dataSourceMetaMap.size() == 0) {
            defaultDsmName = dsmName;
        }
        if (dataSourceMetaMap.containsKey(dsmName)) {
            logger.error("Contains multiple dataSources for dsmName '%s'.", new Object[]{dsmName});
        }
        return dataSourceMetaMap.put(dsmName, dsm);
    }

    static TableMeta addTableMeta(TableMeta tableMeta) {
        return Metadata.addTableMeta(tableMeta.getModelClass(), tableMeta);
    }

    static TableMeta addTableMeta(Class<? extends Entity> clazz, TableMeta tableMeta) {
        String dsmName = tableMeta.getDsmName();
        Checker.checkNotNull((Object)dsmName, (Object)"DataSourceMetaName could not be null.");
        if (dsmName.contains(CONNECTOR)) {
            throw new IllegalArgumentException("DataSourceMetaName not support '@' for name '" + dsmName + "'.");
        }
        String tableName = tableMeta.getTableName();
        Checker.checkNotNull((Object)tableName, (Object)"TableName could not be null.");
        if (tableName.contains(CONNECTOR)) {
            throw new IllegalArgumentException("TableName not support '@' for name '" + tableName + "'.");
        }
        String mark = Metadata.getMark(dsmName, tableName);
        if (clazz != null) {
            if (tableMetaClassMap.containsKey(clazz)) {
                logger.error("Covering multiple class '" + clazz + "' for table '" + tableName + "' in '" + dsmName + "'.");
            }
            tableMetaClassMap.put(clazz, mark);
        }
        tableMetaMap.put(mark, tableMeta);
        return tableMeta;
    }

    public static String getDefaultDsmName() {
        return defaultDsmName;
    }

    static String getMark(String dsmName, String tableName) {
        return dsmName + CONNECTOR + tableName;
    }

    static {
        dataSourceMetaMap = new HashMap<String, DataSourceMeta>();
        tableMetaMap = new HashMap<String, TableMeta>();
        tableMetaClassMap = new HashMap<Class<? extends Entity>, String>();
    }
}

