/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm;

import cn.dreampie.common.Constant;
import cn.dreampie.log.Logger;
import cn.dreampie.orm.TransactionManager;
import cn.dreampie.orm.dialect.Dialect;
import cn.dreampie.orm.exception.TransactionException;
import cn.dreampie.orm.provider.DataSourceProvider;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class DataSourceMeta {
    private static final Logger logger = Logger.getLogger(DataSourceMeta.class);
    private final ThreadLocal<Connection> connectionHolder = new ThreadLocal();
    private final ThreadLocal<TransactionManager> transactionManagerHolder = new ThreadLocal();
    private final ThreadLocal<Integer> transactionDeepHolder = new ThreadLocal();
    private final String dsmName;
    private DataSourceProvider writeDataSourceProvider;
    private DataSourceProvider readDataSourceProvider;

    public DataSourceMeta(DataSourceProvider writeDataSourceProvider) {
        this(writeDataSourceProvider.getDsName(), writeDataSourceProvider, null);
    }

    public DataSourceMeta(String dsmName, DataSourceProvider writeDataSourceProvider, DataSourceProvider readDataSourceProvider) {
        this.dsmName = dsmName;
        this.writeDataSourceProvider = writeDataSourceProvider;
        this.readDataSourceProvider = readDataSourceProvider;
        if (readDataSourceProvider != null && !writeDataSourceProvider.getDialect().equals(readDataSourceProvider.getDialect())) {
            throw new IllegalArgumentException("Different read and write database dialect");
        }
    }

    public String getDsmName() {
        return this.dsmName;
    }

    public Dialect getDialect() {
        return this.writeDataSourceProvider.getDialect();
    }

    public String getWriteDsName() {
        return this.writeDataSourceProvider.getDsName();
    }

    DataSource getWriteDataSource() {
        return this.writeDataSourceProvider.getDataSource();
    }

    public boolean isWriteShowSql() {
        return this.writeDataSourceProvider.isShowSql();
    }

    public String getReadDsName() {
        if (this.readDataSourceProvider != null) {
            return this.readDataSourceProvider.getDsName();
        }
        return this.getWriteDsName();
    }

    DataSource getReadDataSource() {
        if (this.readDataSourceProvider != null) {
            return this.readDataSourceProvider.getDataSource();
        }
        return this.getWriteDataSource();
    }

    public boolean isReadShowSql() {
        if (this.readDataSourceProvider != null) {
            return this.readDataSourceProvider.isShowSql();
        }
        return this.isWriteShowSql();
    }

    public Connection getWriteConnection() throws SQLException {
        Connection conn = this.connectionHolder.get();
        if (conn != null) {
            return conn;
        }
        return this.getWriteDataSource().getConnection();
    }

    public Connection getReadConnection() throws SQLException {
        Connection conn = this.connectionHolder.get();
        if (conn != null) {
            return conn;
        }
        if (this.readDataSourceProvider != null) {
            return this.getReadDataSource().getConnection();
        }
        return this.getWriteDataSource().getConnection();
    }

    Connection getCurrentConnection() {
        return this.connectionHolder.get();
    }

    void setCurrentConnection(Connection connection) {
        this.connectionHolder.set(connection);
    }

    void rmCurrentConnection() {
        this.connectionHolder.remove();
    }

    public void initTransaction(boolean readonly, int level) {
        if (this.transactionManagerHolder.get() == null) {
            this.transactionManagerHolder.set(new TransactionManager(this, readonly, level));
            this.transactionDeepHolder.set(1);
        } else {
            this.transactionDeepHolder.set(this.transactionDeepHolder.get() + 1);
        }
    }

    public void beginTransaction() throws TransactionException {
        TransactionManager transactionManager = this.transactionManagerHolder.get();
        if (transactionManager != null && !transactionManager.isBegined()) {
            transactionManager.begin();
        }
    }

    public void commitTransaction() throws TransactionException {
        TransactionManager transactionManager;
        if (this.transactionDeepHolder.get() == 1 && (transactionManager = this.transactionManagerHolder.get()) != null) {
            transactionManager.commit();
        }
    }

    public void rollbackTransaction() {
        TransactionManager transactionManager;
        if (this.transactionDeepHolder.get() == 1 && (transactionManager = this.transactionManagerHolder.get()) != null) {
            transactionManager.rollback();
        }
    }

    public void endTranasaction() {
        if (this.transactionDeepHolder.get() == 1) {
            TransactionManager transactionManager = this.transactionManagerHolder.get();
            if (transactionManager != null) {
                transactionManager.end();
            }
            this.transactionManagerHolder.remove();
        } else {
            this.transactionDeepHolder.set(this.transactionDeepHolder.get() - 1);
        }
    }

    public final void close() {
        Connection connection = this.connectionHolder.get();
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            logger.warn("Could not close connection!", (Throwable)e);
        }
        if (!Constant.devEnable) {
            this.writeDataSourceProvider.close();
            if (this.readDataSourceProvider != null) {
                this.readDataSourceProvider.close();
            }
        }
    }

    public final void close(ResultSet rs, Statement st, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warn("Could not close resultSet!", (Throwable)e);
            }
        }
        this.close(st, conn);
    }

    public final void close(Statement st, Connection conn) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                logger.warn("Could not close statement!", (Throwable)e);
            }
        }
        this.close(conn);
    }

    public final void close(Connection conn) {
        if (this.connectionHolder.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.warn("Could not close connection!", (Throwable)e);
            }
        }
    }
}

