/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm;

import cn.dreampie.common.entity.Conversion;
import cn.dreampie.orm.Base;
import cn.dreampie.orm.DataSourceMeta;
import cn.dreampie.orm.Record;
import cn.dreampie.orm.TableMeta;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class BaseBuilder {
    public static <T> List<T> build(ResultSet rs, Class<? extends Base> modelClass, DataSourceMeta dataSourceMeta, TableMeta tableMeta) throws SQLException, InstantiationException, IllegalAccessException {
        ArrayList<Base> result = new ArrayList<Base>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        BaseBuilder.buildLabelNamesAndTypes(rsmd, labelNames, types);
        while (rs.next()) {
            Base entity = Record.class.isAssignableFrom(modelClass) ? new Record(tableMeta) : modelClass.newInstance();
            for (int i = 1; i <= columnCount; ++i) {
                Object value = rs.getObject(i);
                String name = labelNames[i];
                Conversion conversion = entity.getConversion(name);
                if (conversion != null) {
                    value = conversion.read(value);
                }
                entity.init(name, value);
            }
            result.add(entity);
        }
        return result;
    }

    private static void buildLabelNamesAndTypes(ResultSetMetaData rsmd, String[] labelNames, int[] types) throws SQLException {
        for (int i = 1; i < labelNames.length; ++i) {
            labelNames[i] = rsmd.getColumnLabel(i);
            types[i] = rsmd.getColumnType(i);
        }
    }
}

