/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm;

import cn.dreampie.common.entity.Conversion;
import cn.dreampie.common.entity.Entity;
import cn.dreampie.common.entity.exception.EntityException;
import cn.dreampie.common.util.Checker;
import cn.dreampie.common.util.Joiner;
import cn.dreampie.log.Logger;
import cn.dreampie.orm.BaseBuilder;
import cn.dreampie.orm.DataSourceMeta;
import cn.dreampie.orm.Metadata;
import cn.dreampie.orm.TableMeta;
import cn.dreampie.orm.cache.QueryCache;
import cn.dreampie.orm.callable.ObjectCall;
import cn.dreampie.orm.callable.ResultSetCall;
import cn.dreampie.orm.dialect.Dialect;
import cn.dreampie.orm.exception.DBException;
import cn.dreampie.orm.generate.Generator;
import cn.dreampie.orm.page.FullPage;
import cn.dreampie.orm.page.Page;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class Base<M extends Base>
extends Entity<M>
implements Externalizable {
    public static final String DEFAULT_GENERATED_KEY = "id";
    private final Logger logger = Logger.getLogger(this.getClass());
    private String alias;

    protected Class<? extends M> getMClass() {
        Class<?> clazz = this.getClass();
        Type[] actualTypeArguments = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
        if (actualTypeArguments.length > 0) {
            return (Class)actualTypeArguments[0];
        }
        return clazz;
    }

    public Conversion getConversion(String attr) {
        return null;
    }

    protected abstract TableMeta getTableMeta();

    public boolean hasColumn(String attr) {
        return this.getTableMeta().hasColumn(attr);
    }

    public Class getColumnType(String attr) {
        return this.getDialect().getColumnType(this.getTableMeta().getDataType(attr));
    }

    protected DataSourceMeta getDataSourceMeta() {
        return Metadata.getDataSourceMeta(this.getTableMeta().getDsmName());
    }

    protected Dialect getDialect() {
        return this.getDataSourceMeta().getDialect();
    }

    protected abstract boolean isUseCache();

    public abstract M unCache();

    public abstract M useDSM(String var1);

    public String getAlias() {
        return this.alias;
    }

    public M setAlias(String alias) {
        if (this.alias != null) {
            throw new EntityException("Model alias only set once.");
        }
        this.alias = alias;
        return (M)this;
    }

    protected <T> T getCache(String sql, Object[] params) {
        TableMeta tableMeta = this.getTableMeta();
        if (tableMeta.isCached()) {
            return QueryCache.instance().get(tableMeta.getDsmName(), tableMeta.getTableName(), this.getMClass().getSimpleName(), sql, params);
        }
        return null;
    }

    protected void addCache(String sql, Object[] params, Object cache) {
        TableMeta tableMeta = this.getTableMeta();
        if (tableMeta.isCached()) {
            QueryCache.instance().add(tableMeta.getDsmName(), tableMeta.getTableName(), this.getMClass().getSimpleName(), sql, params, cache, tableMeta.getExpired());
        }
    }

    public void purgeCache() {
        TableMeta tableMeta = this.getTableMeta();
        if (tableMeta.isCached()) {
            QueryCache.instance().purge(tableMeta.getDsmName(), tableMeta.getTableName());
        }
    }

    protected void removeCache(String sql, Object[] params) {
        TableMeta tableMeta = this.getTableMeta();
        if (tableMeta.isCached()) {
            QueryCache.instance().remove(tableMeta.getDsmName(), tableMeta.getTableName(), this.getMClass().getSimpleName(), sql, params);
        }
    }

    private void logSql(boolean showSql, String sql, Object[][] params) {
        if (showSql && this.logger.isInfoEnabled()) {
            StringBuilder log = new StringBuilder("Sql: {").append(sql).append("} ");
            if (params != null && params.length > 0) {
                int i = 0;
                for (Object[] para : params) {
                    log.append(", params[").append(i++).append("]: ").append('{');
                    log.append(Joiner.on((String)"}, {").useForNull("null").join(para));
                    log.append('}');
                }
            }
            log.append('\n');
            this.logger.info(log.toString());
        }
    }

    private void logSql(boolean showSql, String sql, Object[] params) {
        if (showSql && this.logger.isInfoEnabled()) {
            StringBuilder log = new StringBuilder("Sql: {").append(sql).append("} ");
            if (params != null && params.length > 0) {
                log.append(", params: ").append('{');
                log.append(Joiner.on((String)"}, {").useForNull("null").join(params));
                log.append('}');
            }
            this.logger.info(log.toString());
        }
    }

    private void logSql(boolean showSql, List<String> sqls) {
        if (showSql && this.logger.isInfoEnabled()) {
            this.logger.info("Sqls: {" + Joiner.on((String)"}, {").useForNull("null").join(sqls) + '}');
        }
    }

    private Connection getWriteConnection(DataSourceMeta dataSourceMeta) throws SQLException {
        dataSourceMeta.beginTransaction();
        return dataSourceMeta.getWriteConnection();
    }

    private Connection getReadConnection(DataSourceMeta dataSourceMeta) throws SQLException {
        dataSourceMeta.beginTransaction();
        return dataSourceMeta.getReadConnection();
    }

    private PreparedStatement getPreparedStatement(boolean showSql, boolean needGeneratedKey, Connection conn, TableMeta tableMeta, String sql, Object[] params) throws SQLException {
        this.logSql(showSql, sql, params);
        String generatedKey = tableMeta.getGeneratedKey();
        boolean generated = tableMeta.getGenerator() == null && !generatedKey.isEmpty();
        PreparedStatement pst = generated && needGeneratedKey ? conn.prepareStatement(sql, new String[]{generatedKey}) : conn.prepareStatement(sql);
        for (int i = 0; i < params.length; ++i) {
            pst.setObject(i + 1, params[i]);
        }
        return pst;
    }

    private PreparedStatement getPreparedStatement(boolean showSql, boolean needGeneratedKey, Connection conn, TableMeta tableMeta, String sql, Object[][] params) throws SQLException {
        boolean generated;
        this.logSql(showSql, sql, params);
        PreparedStatement pst = null;
        String generatedKey = tableMeta.getGeneratedKey();
        boolean bl = generated = tableMeta.getGenerator() == null && !generatedKey.isEmpty();
        if (generated && needGeneratedKey) {
            String[] returnKeys = new String[params.length];
            for (int i = 0; i < params.length; ++i) {
                returnKeys[i] = generatedKey;
            }
            pst = conn.prepareStatement(sql, returnKeys);
        } else {
            pst = conn.prepareStatement(sql);
        }
        int batchSize = 1000;
        int count = 0;
        for (Object[] para : params) {
            for (int j = 0; j < para.length; ++j) {
                pst.setObject(j + 1, para[j]);
            }
            pst.addBatch();
            if (++count % 1000 != 0) continue;
            pst.executeBatch();
        }
        return pst;
    }

    private Statement getPreparedStatement(boolean showSql, Connection conn, List<String> sqls) throws SQLException {
        this.logSql(showSql, sqls);
        Statement stmt = null;
        stmt = conn.createStatement();
        int batchSize = 1000;
        int count = 0;
        for (String aSql : sqls) {
            stmt.addBatch(aSql);
            if (++count % 1000 != 0) continue;
            stmt.executeBatch();
        }
        return stmt;
    }

    private String getPrimaryKey(TableMeta tableMeta) {
        String generatedKey = tableMeta.getGeneratedKey();
        if (generatedKey.isEmpty()) {
            String[] primaryKeys = this.getPrimaryKeys(tableMeta);
            if (primaryKeys.length > 0) {
                generatedKey = primaryKeys[0];
            } else {
                throw new IllegalArgumentException("Your table must have least one generatedKey or primaryKey.");
            }
        }
        return generatedKey;
    }

    private String[] getPrimaryKeys(TableMeta tableMeta) {
        String[] keys;
        String generatedKey = tableMeta.getGeneratedKey();
        String[] primaryKey = tableMeta.getPrimaryKey();
        int i = 0;
        if (!generatedKey.isEmpty()) {
            keys = new String[primaryKey.length + 1];
            keys[i++] = generatedKey;
        } else {
            keys = new String[primaryKey.length];
        }
        for (String pKey : primaryKey) {
            keys[i++] = pKey;
        }
        if (keys.length <= 0) {
            throw new IllegalArgumentException("Your table must have least one generatedKey or primaryKey.");
        }
        return keys;
    }

    private Object[] getPrimaryValues(TableMeta tableMeta) {
        Object[] values;
        Map attrs = this.getAttrs();
        String generatedKey = tableMeta.getGeneratedKey();
        Object id = null;
        if (!generatedKey.isEmpty()) {
            id = attrs.get(generatedKey);
            Checker.checkNotNull(id, (Object)("You can't delete model without generatedKey " + generatedKey + "."));
        }
        String[] primaryKeys = tableMeta.getPrimaryKey();
        int i = 0;
        if (!generatedKey.isEmpty()) {
            values = new Object[primaryKeys.length + 1];
            values[i++] = id;
        } else {
            values = new Object[primaryKeys.length];
        }
        for (String pKey : primaryKeys) {
            values[i++] = attrs.get(pKey);
        }
        if (values.length <= 0) {
            throw new IllegalArgumentException("Your must set generatedKey or primaryKey.");
        }
        return values;
    }

    protected void setGeneratedKey(PreparedStatement pst, TableMeta tableMeta) throws SQLException {
        ResultSet rs;
        boolean generated;
        String generatedKey = tableMeta.getGeneratedKey();
        boolean bl = generated = tableMeta.getGenerator() == null && !generatedKey.isEmpty();
        if (generated && this.get(generatedKey) == null && (rs = pst.getGeneratedKeys()).next()) {
            this.set(generatedKey, rs.getObject(1));
            rs.close();
        }
    }

    protected void setGeneratedKey(PreparedStatement pst, TableMeta tableMeta, List<? extends Entity> models) throws SQLException {
        boolean generated;
        String generatedKey = tableMeta.getGeneratedKey();
        boolean bl = generated = tableMeta.getGenerator() == null && !generatedKey.isEmpty();
        if (generated) {
            ResultSet rs = pst.getGeneratedKeys();
            for (Entity entity : models) {
                if (entity.get(generatedKey) != null || !rs.next()) continue;
                entity.set(generatedKey, rs.getObject(1));
            }
            rs.close();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<M> find(String sql, Object ... params) {
        List result = null;
        boolean useCache = this.isUseCache();
        TableMeta tableMeta = this.getTableMeta();
        if (useCache) {
            result = (List)this.getCache(sql, params);
            if (result != null) {
                return result;
            }
        } else {
            this.logger.debug("This query not use cache.");
        }
        DataSourceMeta dsm = this.getDataSourceMeta();
        boolean showSql = dsm.isReadShowSql();
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            conn = this.getReadConnection(dsm);
            pst = this.getPreparedStatement(showSql, false, conn, tableMeta, sql, params);
            rs = pst.executeQuery();
            result = BaseBuilder.build(rs, this.getMClass(), dsm, tableMeta);
            dsm.close(rs, pst, conn);
        }
        catch (SQLException e) {
            try {
                throw new DBException(e.getMessage(), e);
                catch (InstantiationException e2) {
                    throw new EntityException(e2.getMessage(), (Throwable)e2);
                }
                catch (IllegalAccessException e3) {
                    throw new EntityException(e3.getMessage(), (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                dsm.close(rs, pst, conn);
                throw throwable;
            }
        }
        this.addCache(sql, params, result);
        return result;
    }

    public M findFirst(String sql, Object ... params) {
        TableMeta tableMeta = this.getTableMeta();
        List<M> result = this.find(tableMeta.getDialect().paginateWith(1, 1, sql), params);
        return (M)(result.size() > 0 ? (Base)result.get(0) : null);
    }

    public M findById(Object id) {
        return this.findColsById("*", id);
    }

    public M findByIds(Object ... ids) {
        return this.findColsByIds("*", ids);
    }

    public List<M> findInIds(Object ... ids) {
        return this.findColsInIds("*", ids);
    }

    public M findColsById(String columns, Object id) {
        TableMeta tableMeta = this.getTableMeta();
        String key = this.getPrimaryKey(tableMeta);
        Dialect dialect = this.getDialect();
        String sql = dialect.select(tableMeta.getTableName(), "", key + "=?", columns.split(","));
        return this.findFirst(sql, id);
    }

    public M findColsByIds(String columns, Object ... ids) {
        TableMeta tableMeta = this.getTableMeta();
        Object[] keys = this.getPrimaryKeys(tableMeta);
        String sql = this.getDialect().select(tableMeta.getTableName(), "", Joiner.on((String)"=? AND ").join(keys) + "=?", columns.split(","));
        return this.findFirst(sql, ids);
    }

    public List<M> findColsInIds(String columns, Object ... ids) {
        TableMeta tableMeta = this.getTableMeta();
        String key = this.getPrimaryKey(tableMeta);
        Dialect dialect = this.getDialect();
        StringBuilder appendQuestions = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            if (i == 0) {
                appendQuestions.append("?");
                continue;
            }
            appendQuestions.append(",?");
        }
        String sql = dialect.select(tableMeta.getTableName(), "", key + " IN (" + appendQuestions + ")", columns.split(","));
        return this.find(sql, ids);
    }

    public Page<M> paginate(int pageNumber, int pageSize, String sql, Object ... params) {
        Checker.checkArgument((pageNumber >= 1 && pageSize >= 1 ? 1 : 0) != 0, (Object)"pageNumber and pageSize must be more than 0");
        DataSourceMeta dsm = this.getDataSourceMeta();
        Dialect dialect = dsm.getDialect();
        List<M> list = this.find(dialect.paginateWith(pageNumber, pageSize, sql), params);
        return new Page<M>(list, pageNumber, pageSize);
    }

    public FullPage<M> fullPaginate(int pageNumber, int pageSize, String sql, Object ... params) {
        Checker.checkArgument((pageNumber >= 1 && pageSize >= 1 ? 1 : 0) != 0, (Object)"pageNumber and pageSize must be more than 0");
        DataSourceMeta dsm = this.getDataSourceMeta();
        Dialect dialect = dsm.getDialect();
        long totalRow = 0L;
        int totalPage = 0;
        List result = this.query(dialect.countWith(sql), params);
        int size = result.size();
        if (size == 1) {
            totalRow = ((Number)result.get(0)).longValue();
        } else if (size > 1) {
            totalRow = result.size();
        } else {
            return new FullPage(new ArrayList(0), pageNumber, pageSize, 0, 0);
        }
        totalPage = (int)(totalRow / (long)pageSize);
        if (totalRow % (long)pageSize != 0L) {
            ++totalPage;
        }
        List<M> list = this.find(dialect.paginateWith(pageNumber, pageSize, sql), params);
        return new FullPage<M>(list, pageNumber, pageSize, totalPage, (int)totalRow);
    }

    public boolean save() {
        boolean generated;
        TableMeta tableMeta = this.getTableMeta();
        this.purgeCache();
        String generatedKey = tableMeta.getGeneratedKey();
        Generator generator = tableMeta.getGenerator();
        boolean bl = generated = generator == null && !generatedKey.isEmpty();
        if (!generated && generator != null && this.get(generatedKey) == null) {
            this.set(generatedKey, generator.generateKey());
        }
        DataSourceMeta dsm = this.getDataSourceMeta();
        boolean showSql = dsm.isWriteShowSql();
        Dialect dialect = dsm.getDialect();
        String[] columns = generated ? this.getModifyAttrNames(generatedKey) : this.getModifyAttrNames();
        Object[] params = generated ? this.getModifyAttrValues(generatedKey) : this.getModifyAttrValues();
        if (columns.length <= 0) {
            this.logger.warn("Could not found any data to save.");
            return false;
        }
        String sql = dialect.insert(tableMeta.getTableName(), tableMeta.getGeneratedKey(), tableMeta.getSequence(), columns);
        Connection conn = null;
        PreparedStatement pst = null;
        int result = 0;
        try {
            conn = this.getWriteConnection(dsm);
            pst = this.getPreparedStatement(showSql, true, conn, tableMeta, sql, params);
            result = pst.executeUpdate();
            this.setGeneratedKey(pst, tableMeta);
            this.clearModifyAttrs();
            boolean bl2 = result >= 1;
            dsm.close(pst, conn);
            return bl2;
        }
        catch (SQLException e) {
            try {
                throw new DBException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                dsm.close(pst, conn);
                throw throwable;
            }
        }
    }

    public boolean save(M ... models) {
        return this.save(Arrays.asList(models));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save(List<M> models) {
        boolean generated;
        if (models == null || models.size() <= 0) {
            this.logger.warn("Cloud not found models to save.");
            return false;
        }
        Base firstModel = (Base)models.get(0);
        if (models.size() == 1) {
            return firstModel.save();
        }
        TableMeta tableMeta = firstModel.getTableMeta();
        firstModel.purgeCache();
        String generatedKey = tableMeta.getGeneratedKey();
        Generator generator = tableMeta.getGenerator();
        boolean bl = generated = generator == null && !generatedKey.isEmpty();
        if (!generated && generator != null && this.get(generatedKey) == null) {
            firstModel.set(generatedKey, generator.generateKey());
        }
        DataSourceMeta dsm = firstModel.getDataSourceMeta();
        boolean showSql = dsm.isWriteShowSql();
        Dialect dialect = dsm.getDialect();
        String[] columns = generated ? firstModel.getModifyAttrNames(generatedKey) : firstModel.getModifyAttrNames();
        if (columns.length <= 0) {
            this.logger.warn("Could not found any data to save.");
            return false;
        }
        String sql = dialect.insert(tableMeta.getTableName(), tableMeta.getGeneratedKey(), tableMeta.getSequence(), columns);
        Object[][] params = new Object[models.size()][columns.length];
        for (int i = 0; i < params.length; ++i) {
            for (int j = 0; j < params[i].length; ++j) {
                if (!generated && columns[j].equals(generatedKey) && ((Base)models.get(i)).get(generatedKey) == null) {
                    ((Base)models.get(i)).set(columns[j], generator.generateKey());
                }
                String name = columns[j];
                Object value = ((Base)models.get(i)).get(name);
                Conversion conversion = ((Base)models.get(i)).getConversion(name);
                if (conversion != null) {
                    value = conversion.write(value);
                }
                params[i][j] = value;
            }
        }
        Connection conn = null;
        PreparedStatement pst = null;
        Boolean autoCommit = null;
        int[] result = null;
        try {
            conn = this.getWriteConnection(dsm);
            autoCommit = conn.getAutoCommit();
            if (autoCommit.booleanValue()) {
                conn.setAutoCommit(false);
            }
            pst = this.getPreparedStatement(showSql, true, conn, tableMeta, sql, params);
            result = pst.executeBatch();
            this.setGeneratedKey(pst, tableMeta, models);
            if (dsm.getCurrentConnection() == null) {
                conn.commit();
            }
            conn.setAutoCommit(autoCommit);
            for (Base model : models) {
                model.clearModifyAttrs();
            }
            for (int r : result) {
                if (r >= 1) continue;
                boolean bl2 = false;
                dsm.close(pst, conn);
                return bl2;
            }
            boolean arr$ = true;
            dsm.close(pst, conn);
            return arr$;
        }
        catch (SQLException e) {
            try {
                throw new DBException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                dsm.close(pst, conn);
                throw throwable;
            }
        }
    }

    public boolean update(String sql, Object ... params) {
        TableMeta tableMeta = this.getTableMeta();
        DataSourceMeta dsm = this.getDataSourceMeta();
        boolean showSql = dsm.isWriteShowSql();
        this.purgeCache();
        int result = -1;
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            conn = this.getWriteConnection(dsm);
            pst = this.getPreparedStatement(showSql, true, conn, tableMeta, sql, params);
            result = pst.executeUpdate();
            dsm.close(pst, conn);
        }
        catch (SQLException e) {
            try {
                throw new DBException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                dsm.close(pst, conn);
                throw throwable;
            }
        }
        return result > 0;
    }

    public boolean update() {
        Object[] keys;
        Object[] ids;
        TableMeta tableMeta = this.getTableMeta();
        Dialect dialect = this.getDialect();
        String generatedKey = tableMeta.getGeneratedKey();
        String[] columns = this.getModifyAttrNames(generatedKey);
        if (columns.length <= 0) {
            this.logger.warn("Could not found any modified attributes.");
            return false;
        }
        boolean hasGeneratedKey = !generatedKey.isEmpty();
        Object id = null;
        if (hasGeneratedKey) {
            id = this.get(generatedKey);
            Checker.checkNotNull((Object)id, (Object)("You can't update model without Generated Key " + generatedKey + "."));
        }
        String where = null;
        Object[] params = null;
        Object[] values = this.getModifyAttrValues(generatedKey);
        String[] pkeys = tableMeta.getPrimaryKey();
        int i = 0;
        int j = 0;
        if (hasGeneratedKey) {
            ids = new Object[pkeys.length + 1];
            keys = new String[pkeys.length + 1];
            keys[j++] = generatedKey;
            ids[i++] = id;
        } else {
            ids = new Object[pkeys.length];
            keys = new String[pkeys.length];
        }
        for (String pKey : pkeys) {
            keys[j++] = pKey;
            ids[i++] = this.get(pKey);
        }
        if (ids.length > 0) {
            params = new Object[ids.length + values.length];
            System.arraycopy(values, 0, params, 0, values.length);
            System.arraycopy(ids, 0, params, values.length, ids.length);
            where = Joiner.on((String)"=? AND ").join(keys) + "=?";
        } else {
            params = values;
        }
        String sql = dialect.update(tableMeta.getTableName(), this.getAlias(), where, columns);
        if (this.update(sql, params)) {
            this.clearModifyAttrs();
            return true;
        }
        return false;
    }

    public boolean execute(String ... sqls) {
        return this.execute(Arrays.asList(sqls));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(List<String> sqls) {
        DataSourceMeta dsm = this.getDataSourceMeta();
        boolean showSql = dsm.isWriteShowSql();
        Statement stmt = null;
        int[] result = null;
        Connection conn = null;
        Boolean autoCommit = null;
        try {
            conn = this.getWriteConnection(dsm);
            autoCommit = conn.getAutoCommit();
            if (autoCommit.booleanValue()) {
                conn.setAutoCommit(false);
            }
            stmt = this.getPreparedStatement(showSql, conn, sqls);
            result = stmt.executeBatch();
            if (dsm.getCurrentConnection() == null) {
                conn.commit();
            }
            conn.setAutoCommit(autoCommit);
            for (int r : result) {
                if (r >= 1) continue;
                boolean bl = false;
                dsm.close(stmt, conn);
                return bl;
            }
            boolean arr$ = true;
            dsm.close(stmt, conn);
            return arr$;
        }
        catch (SQLException e) {
            try {
                throw new DBException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                dsm.close(stmt, conn);
                throw throwable;
            }
        }
    }

    public boolean delete() {
        Object[] ids = this.getPrimaryValues(this.getTableMeta());
        return this.deleteByIds(ids);
    }

    public boolean deleteById(Object id) {
        Checker.checkNotNull((Object)id, (Object)"You can't delete model without primaryKey.");
        TableMeta tableMeta = this.getTableMeta();
        String key = this.getPrimaryKey(tableMeta);
        String sql = this.getDialect().delete(tableMeta.getTableName(), key + "=?");
        return this.update(sql, id);
    }

    public boolean deleteByIds(Object ... ids) {
        Checker.checkNotNull((Object)ids, (Object)"You can't delete model without primaryKey.");
        TableMeta tableMeta = this.getTableMeta();
        Object[] keys = this.getPrimaryKeys(tableMeta);
        String sql = this.getDialect().delete(tableMeta.getTableName(), Joiner.on((String)"=? AND ").join(keys) + "=?");
        return this.update(sql, ids);
    }

    public boolean deleteInIds(Object ... ids) {
        Checker.checkNotNull((Object)ids, (Object)"You can't delete model without primaryKey.");
        TableMeta tableMeta = this.getTableMeta();
        String key = this.getPrimaryKey(tableMeta);
        Dialect dialect = this.getDialect();
        StringBuilder appendQuestions = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            if (i == 0) {
                appendQuestions.append("?");
                continue;
            }
            appendQuestions.append(",?");
        }
        String sql = dialect.delete(tableMeta.getTableName(), key + " IN (" + appendQuestions + ")");
        return this.update(sql, ids);
    }

    public List<M> findAll() {
        return this.find(this.getDialect().select(this.getTableMeta().getTableName()), new Object[0]);
    }

    public List<M> findColsAll(String columns) {
        return this.find(this.getDialect().select(this.getTableMeta().getTableName(), columns.split(",")), new Object[0]);
    }

    public List<M> findBy(String where, Object ... params) {
        return this.find(this.getDialect().select(this.getTableMeta().getTableName(), this.getAlias(), where), params);
    }

    public List<M> findColsBy(String colums, String where, Object ... params) {
        return this.find(this.getDialect().select(this.getTableMeta().getTableName(), this.getAlias(), where, colums.split(",")), params);
    }

    public List<M> findTopBy(int topNumber, String where, Object ... params) {
        return this.paginate(1, topNumber, this.getDialect().select(this.getTableMeta().getTableName(), this.getAlias(), where), params).getList();
    }

    public List<M> findColsTopBy(int topNumber, String columns, String where, Object ... params) {
        return this.paginate(1, topNumber, this.getDialect().select(this.getTableMeta().getTableName(), this.getAlias(), where, columns.split(",")), params).getList();
    }

    public M findFirstBy(String where, Object ... params) {
        return this.findFirst(this.getDialect().select(this.getTableMeta().getTableName(), this.getAlias(), where), params);
    }

    public M findColsFirstBy(String columns, String where, Object ... params) {
        return this.findFirst(this.getDialect().select(this.getTableMeta().getTableName(), this.getAlias(), where, columns.split(",")), params);
    }

    public Page<M> paginateAll(int pageNumber, int pageSize) {
        return this.paginate(pageNumber, pageSize, this.getDialect().select(this.getTableMeta().getTableName()), new Object[0]);
    }

    public Page<M> paginateColsAll(int pageNumber, int pageSize, String columns) {
        return this.paginate(pageNumber, pageSize, this.getDialect().select(this.getTableMeta().getTableName(), columns.split(",")), new Object[0]);
    }

    public Page<M> paginateBy(int pageNumber, int pageSize, String where, Object ... params) {
        return this.paginate(pageNumber, pageSize, this.getDialect().select(this.getTableMeta().getTableName(), this.getAlias(), where), params);
    }

    public Page<M> paginateColsBy(int pageNumber, int pageSize, String columns, String where, Object ... params) {
        return this.paginate(pageNumber, pageSize, this.getDialect().select(this.getTableMeta().getTableName(), this.getAlias(), where, columns.split(",")), params);
    }

    public FullPage<M> fullPaginateAll(int pageNumber, int pageSize) {
        return this.fullPaginate(pageNumber, pageSize, this.getDialect().select(this.getTableMeta().getTableName()), new Object[0]);
    }

    public FullPage<M> fullPaginateColsAll(int pageNumber, int pageSize, String columns) {
        return this.fullPaginate(pageNumber, pageSize, this.getDialect().select(this.getTableMeta().getTableName(), columns.split(",")), new Object[0]);
    }

    public FullPage<M> fullPaginateBy(int pageNumber, int pageSize, String where, Object ... params) {
        return this.fullPaginate(pageNumber, pageSize, this.getDialect().select(this.getTableMeta().getTableName(), this.getAlias(), where), params);
    }

    public FullPage<M> fullPaginateColsBy(int pageNumber, int pageSize, String columns, String where, Object ... params) {
        return this.fullPaginate(pageNumber, pageSize, this.getDialect().select(this.getTableMeta().getTableName(), this.getAlias(), where, columns.split(",")), params);
    }

    public boolean updateColsAll(String columns, Object ... params) {
        this.logger.warn("You must ensure that \"updateAll()\" method of safety.");
        return this.update(this.getDialect().update(this.getTableMeta().getTableName(), columns.split(",")), params);
    }

    public boolean updateColsBy(String columns, String where, Object ... params) {
        return this.update(this.getDialect().update(this.getTableMeta().getTableName(), this.getAlias(), where, columns.split(",")), params);
    }

    public boolean deleteAll() {
        this.logger.warn("You must ensure that \"deleteAll()\" method of safety.");
        return this.update(this.getDialect().delete(this.getTableMeta().getTableName()), new Object[0]);
    }

    public boolean deleteBy(String where, Object ... params) {
        return this.update(this.getDialect().delete(this.getTableMeta().getTableName(), where), params);
    }

    public Long countAll() {
        return new Long(this.queryFirst(this.getDialect().count(this.getTableMeta().getTableName()), new Object[0]).toString());
    }

    public Long countBy(String where, Object ... params) {
        return new Long(this.queryFirst(this.getDialect().count(this.getTableMeta().getTableName(), this.getAlias(), where), params).toString());
    }

    public <T> List<T> query(String sql, Object ... params) {
        boolean useCache = this.isUseCache();
        TableMeta tableMeta = this.getTableMeta();
        List<T> result = null;
        if (useCache) {
            result = (List<T>)this.getCache(sql, params);
            if (result != null) {
                return result;
            }
        } else {
            this.logger.debug("This query not use cache.");
        }
        DataSourceMeta dsm = this.getDataSourceMeta();
        boolean showSql = dsm.isReadShowSql();
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            conn = this.getWriteConnection(dsm);
            pst = this.getPreparedStatement(showSql, false, conn, tableMeta, sql, params);
            rs = pst.executeQuery();
            result = this.readQueryResult(rs);
            dsm.close(rs, pst, conn);
        }
        catch (SQLException e) {
            try {
                throw new DBException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                dsm.close(rs, pst, conn);
                throw throwable;
            }
        }
        this.addCache(sql, params, result);
        return result;
    }

    private <T> List<T> readQueryResult(ResultSet rs) throws SQLException {
        ArrayList<Object> result;
        block4: {
            int colAmount;
            block3: {
                result = new ArrayList<Object>();
                colAmount = rs.getMetaData().getColumnCount();
                if (colAmount <= 1) break block3;
                while (rs.next()) {
                    Object[] temp = new Object[colAmount];
                    for (int i = 0; i < colAmount; ++i) {
                        temp[i] = rs.getObject(i + 1);
                    }
                    result.add(temp);
                }
                break block4;
            }
            if (colAmount != 1) break block4;
            while (rs.next()) {
                result.add(rs.getObject(1));
            }
        }
        return result;
    }

    public <T> T queryFirst(String sql, Object ... params) {
        TableMeta tableMeta = this.getTableMeta();
        List<T> result = this.query(tableMeta.getDialect().paginateWith(1, 1, sql), params);
        return result.size() > 0 ? (T)result.get(0) : null;
    }

    public <T> T queryCall(String sql, ObjectCall objectCall) {
        Object object;
        Connection conn = null;
        CallableStatement cstmt = null;
        DataSourceMeta dsm = this.getDataSourceMeta();
        try {
            conn = this.getWriteConnection(dsm);
            cstmt = conn.prepareCall(sql);
            object = objectCall.call(cstmt);
            dsm.close(cstmt, conn);
        }
        catch (SQLException e) {
            try {
                throw new DBException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                dsm.close(cstmt, conn);
                throw throwable;
            }
        }
        return (T)object;
    }

    public <T> List<T> queryCall(String sql, ResultSetCall resultSetCall) {
        Connection conn = null;
        CallableStatement cstmt = null;
        DataSourceMeta dsm = this.getDataSourceMeta();
        try {
            conn = this.getWriteConnection(dsm);
            cstmt = conn.prepareCall(sql);
            List<T> list = this.readQueryResult(resultSetCall.call(cstmt));
            dsm.close(cstmt, conn);
            return list;
        }
        catch (SQLException e) {
            try {
                throw new DBException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                dsm.close(cstmt, conn);
                throw throwable;
            }
        }
    }

    public <T> T queryCallFirst(String sql, ResultSetCall resultSetCall) {
        TableMeta tableMeta = this.getTableMeta();
        List<T> result = this.queryCall(tableMeta.getDialect().paginateWith(1, 1, sql), resultSetCall);
        return result.size() > 0 ? (T)result.get(0) : null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<M> findCall(String sql, ResultSetCall resultSetCall) {
        Connection conn = null;
        CallableStatement cstmt = null;
        DataSourceMeta dsm = this.getDataSourceMeta();
        TableMeta tableMeta = this.getTableMeta();
        try {
            conn = this.getWriteConnection(dsm);
            cstmt = conn.prepareCall(sql);
            List list = BaseBuilder.build(resultSetCall.call(cstmt), this.getMClass(), dsm, tableMeta);
            dsm.close(cstmt, conn);
            return list;
        }
        catch (SQLException e) {
            try {
                throw new DBException(e.getMessage(), e);
                catch (InstantiationException e2) {
                    throw new EntityException(e2.getMessage(), (Throwable)e2);
                }
                catch (IllegalAccessException e3) {
                    throw new EntityException(e3.getMessage(), (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                dsm.close(cstmt, conn);
                throw throwable;
            }
        }
    }

    public M findCallFirst(String sql, ResultSetCall resultSetCall) {
        TableMeta tableMeta = this.getTableMeta();
        List<M> result = this.findCall(tableMeta.getDialect().paginateWith(1, 1, sql), resultSetCall);
        return (M)(result.size() > 0 ? (Base)result.get(0) : null);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.putAttrs((Map)in.readObject());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getAttrs());
    }
}

