/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.orm;

import cn.dreampie.common.Plugin;
import cn.dreampie.common.util.json.Jsoner;
import cn.dreampie.common.util.json.ModelDeserializer;
import cn.dreampie.common.util.json.ModelSerializer;
import cn.dreampie.common.util.scan.ClassScaner;
import cn.dreampie.log.Logger;
import cn.dreampie.orm.DataSourceMeta;
import cn.dreampie.orm.Metadata;
import cn.dreampie.orm.Model;
import cn.dreampie.orm.Record;
import cn.dreampie.orm.TableMeta;
import cn.dreampie.orm.TableMetaBuilder;
import cn.dreampie.orm.provider.DataSourceProvider;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ActiveRecordPlugin
implements Plugin {
    private static final Logger logger = Logger.getLogger(ActiveRecordPlugin.class);
    private Set<Class<? extends Model>> excludeClasses = new HashSet<Class<? extends Model>>();
    private Set<Class<? extends Model>> includeClasses = new HashSet<Class<? extends Model>>();
    private Set<String> includeClassPackages = new HashSet<String>();
    private Set<String> excludeClassPackages = new HashSet<String>();
    private String dsmName;
    private DataSourceProvider writeDataSourceProvider;
    private DataSourceProvider readDataSourceProvider;

    public ActiveRecordPlugin(DataSourceProvider writeDataSourceProvider) {
        this(writeDataSourceProvider.getDsName(), writeDataSourceProvider, null);
    }

    public ActiveRecordPlugin(String dsmName, DataSourceProvider writeDataSourceProvider, DataSourceProvider readDataSourceProvider) {
        this.dsmName = dsmName;
        this.writeDataSourceProvider = writeDataSourceProvider;
        this.readDataSourceProvider = readDataSourceProvider;
    }

    public ActiveRecordPlugin addExcludeClasses(Class<? extends Model> ... classes) {
        Collections.addAll(this.excludeClasses, classes);
        return this;
    }

    public ActiveRecordPlugin addExcludeClasses(Set<Class<? extends Model>> classes) {
        if (classes != null) {
            this.excludeClasses.addAll(classes);
        }
        return this;
    }

    public ActiveRecordPlugin addExcludePackages(String ... packages) {
        Collections.addAll(this.excludeClassPackages, packages);
        return this;
    }

    public ActiveRecordPlugin addIncludeClasses(Class<? extends Model> ... classes) {
        Collections.addAll(this.includeClasses, classes);
        return this;
    }

    public ActiveRecordPlugin addIncludeClasses(Set<Class<? extends Model>> classes) {
        if (classes != null) {
            this.includeClasses.addAll(classes);
        }
        return this;
    }

    public ActiveRecordPlugin addIncludePackages(String ... packages) {
        Collections.addAll(this.includeClassPackages, packages);
        return this;
    }

    public boolean start() {
        if (this.includeClassPackages.size() > 0) {
            if (this.includeClasses.size() <= 0) {
                this.includeClasses = ClassScaner.of(Model.class).include(this.includeClassPackages).scanToClass();
            } else {
                this.includeClasses.addAll(ClassScaner.of(Model.class).include(this.includeClassPackages).scanToClass());
            }
        } else {
            logger.warn("You not include any packages for dsmName: " + this.dsmName);
        }
        DataSourceMeta dsm = new DataSourceMeta(this.dsmName, this.writeDataSourceProvider, this.readDataSourceProvider);
        if (this.includeClasses.size() > 0) {
            HashSet<TableMeta> tableMetas = new HashSet<TableMeta>();
            TableMeta tableMeta = null;
            boolean isExclude = false;
            for (Class<? extends Model> modelClass : this.includeClasses) {
                if (this.excludeClasses.contains(modelClass) || Modifier.isAbstract(modelClass.getModifiers())) continue;
                isExclude = false;
                if (this.excludeClassPackages.size() > 0) {
                    for (String excludepath : this.excludeClassPackages) {
                        if (!modelClass.getName().startsWith(excludepath)) continue;
                        logger.debug("Exclude model:" + modelClass.getName());
                        isExclude = true;
                        break;
                    }
                }
                if (isExclude) continue;
                tableMeta = new TableMeta(this.dsmName, modelClass);
                tableMetas.add(tableMeta);
                logger.info("Models.add(" + tableMeta.getTableName() + ", " + modelClass.getName() + ")");
                Jsoner.addConfig(modelClass, (ObjectSerializer)ModelSerializer.instance(), (ObjectDeserializer)ModelDeserializer.instance());
            }
            TableMetaBuilder.buildTableMeta(tableMetas, dsm);
        } else {
            logger.warn("Could not load any model for '" + this.dsmName + "'.");
        }
        Jsoner.addConfig(Record.class, (ObjectSerializer)ModelSerializer.instance(), (ObjectDeserializer)ModelDeserializer.instance());
        Metadata.addDataSourceMeta(dsm);
        return true;
    }

    public boolean stop() {
        Metadata.close();
        return true;
    }
}

