/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.mail;

import cn.dreampie.common.util.Joiner;
import cn.dreampie.log.Logger;
import cn.dreampie.mail.Mail;
import cn.dreampie.mail.MailException;
import cn.dreampie.mail.MailPlugin;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;

public class MailSender {
    private static Logger logger = Logger.getLogger(MailSender.class);

    public static void sendText(String subject, String body, String ... recipients) {
        try {
            SimpleEmail simpleEmail = MailSender.getSimpleEmail(subject, body, recipients);
            simpleEmail.send();
            logger.info("send email to {}", new Object[]{Joiner.on((String)",").useForNull("null").join((Object[])recipients)});
        }
        catch (EmailException e) {
            throw new MailException("Unabled to send email", e);
        }
    }

    public static SimpleEmail getSimpleEmail(String subject, String body, String ... recipients) throws EmailException {
        SimpleEmail simpleEmail = new SimpleEmail();
        MailSender.configEmail(subject, (Email)simpleEmail, recipients);
        if (body != null) {
            simpleEmail.setMsg(body);
        }
        return simpleEmail;
    }

    public static void sendHtml(String subject, String body, String ... recipients) {
        MailSender.sendHtml(subject, body, null, recipients);
    }

    public static void sendHtml(String subject, String body, EmailAttachment attachment, String ... recipients) {
        try {
            HtmlEmail htmlEmail = MailSender.getHtmlEmail(subject, body, attachment, recipients);
            htmlEmail.send();
            logger.info("send email to {}", new Object[]{Joiner.on((String)",").useForNull("null").join((Object[])recipients)});
        }
        catch (EmailException e) {
            throw new MailException("Unabled to send email", e);
        }
    }

    public static HtmlEmail getHtmlEmail(String subject, String ... recipients) {
        return MailSender.getHtmlEmail(subject, null, null, recipients);
    }

    public static HtmlEmail getHtmlEmail(String subject, String body, EmailAttachment attachment, String ... recipients) {
        try {
            HtmlEmail htmlEmail = new HtmlEmail();
            MailSender.configEmail(subject, (Email)htmlEmail, recipients);
            if (body != null) {
                htmlEmail.setHtmlMsg(body);
            }
            htmlEmail.setTextMsg("Your email client does not support HTML messages");
            if (attachment != null) {
                htmlEmail.attach(attachment);
            }
            return htmlEmail;
        }
        catch (EmailException e) {
            throw new MailException("Unabled to send email", e);
        }
    }

    public static void sendAttachment(String subject, String body, EmailAttachment attachment, String ... recipients) {
        try {
            MultiPartEmail multiPartEmail = MailSender.getMultiPartEmail(subject, body, attachment, recipients);
            multiPartEmail.send();
            logger.info("send email to {}", new Object[]{Joiner.on((String)",").useForNull("null").join((Object[])recipients)});
        }
        catch (EmailException e) {
            throw new MailException("Unabled to send email", e);
        }
    }

    public static MultiPartEmail getMultiPartEmail(String subject, String body, String ... recipients) {
        return MailSender.getMultiPartEmail(subject, body, null, recipients);
    }

    public static MultiPartEmail getMultiPartEmail(String subject, String body, EmailAttachment attachment, String ... recipients) {
        try {
            MultiPartEmail multiPartEmail = new MultiPartEmail();
            MailSender.configEmail(subject, (Email)multiPartEmail, recipients);
            multiPartEmail.setMsg(body);
            if (attachment != null) {
                multiPartEmail.attach(attachment);
            }
            return multiPartEmail;
        }
        catch (EmailException e) {
            throw new MailException("Unabled to send email", e);
        }
    }

    private static void configEmail(String subject, Email email, String ... recipients) throws EmailException {
        if (recipients == null) {
            throw new EmailException("Recipients not found.");
        }
        Mail mail = MailPlugin.getMail();
        email.setCharset(mail.getCharset());
        email.setSocketTimeout(mail.getTimeout());
        email.setSocketConnectionTimeout(mail.getConnectout());
        email.setHostName(mail.getHost());
        if (!mail.getSslport().isEmpty()) {
            email.setSslSmtpPort(mail.getSslport());
        }
        if (!mail.getPort().isEmpty()) {
            email.setSmtpPort(Integer.parseInt(mail.getPort()));
        }
        email.setSSLOnConnect(mail.isSsl());
        email.setStartTLSEnabled(mail.isTls());
        email.setDebug(mail.isDebug());
        email.setAuthentication(mail.getUser(), mail.getPassword());
        email.setFrom(mail.getFrom(), mail.getName());
        email.setSubject(subject);
        email.addTo(recipients);
    }
}

