/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.client;

import cn.dreampie.common.util.Checker;
import cn.dreampie.common.util.HttpTyper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class HttpClientFile {
    private String name;
    private String contentType;
    private InputStream inputStream;

    public HttpClientFile(String filepath) throws FileNotFoundException {
        this(new File(filepath));
    }

    public HttpClientFile(File file) throws FileNotFoundException {
        this.name = file.getName();
        this.contentType = HttpTyper.getContentTypeFromFileName((String)this.name);
        this.inputStream = new FileInputStream(file);
    }

    public HttpClientFile(String name, String contentType, InputStream inputStream) {
        this.name = name;
        this.contentType = contentType;
        this.inputStream = (InputStream)Checker.checkNotNull((Object)inputStream);
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

