/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.client;

import cn.dreampie.client.HttpClientFile;
import cn.dreampie.client.HttpClientRequest;
import cn.dreampie.client.exception.HttpClientException;
import cn.dreampie.common.http.ContentType;
import cn.dreampie.common.util.stream.DefaultFileRenamer;
import cn.dreampie.common.util.stream.FileRenamer;
import cn.dreampie.log.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Random;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpClientConnection {
    private static final Logger logger = Logger.getLogger(HttpClientConnection.class);
    private final SSLSocketFactory sslSocketFactory = this.initSSLSocketFactory();
    private final TrustAnyHostnameVerifier trustAnyHostnameVerifier = new TrustAnyHostnameVerifier();
    protected HttpClientRequest loginRequest;
    protected ThreadLocal<HttpClientRequest> clientRequestTL = new ThreadLocal();
    protected CookieManager cookieManager = new CookieManager();
    protected String apiUrl;
    protected FileRenamer renamer = new DefaultFileRenamer();

    protected HttpClientConnection(String apiUrl) {
        this(apiUrl, null);
    }

    protected HttpClientConnection(String apiUrl, HttpClientRequest loginRequest) {
        this(apiUrl, loginRequest, null);
    }

    protected HttpClientConnection(String apiUrl, HttpClientRequest loginRequest, HttpClientRequest httpClientRequest) {
        this.apiUrl = apiUrl;
        this.loginRequest = loginRequest;
        if (httpClientRequest != null) {
            this.clientRequestTL.set(httpClientRequest);
        } else {
            this.clientRequestTL.set(new HttpClientRequest());
        }
        this.cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(this.cookieManager);
    }

    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public void setRenamer(FileRenamer renamer) {
        if (renamer == null) {
            throw new HttpClientException("FileRenamer must not null.");
        }
        this.renamer = renamer;
    }

    private SSLSocketFactory initSSLSocketFactory() {
        try {
            TrustManager[] tm = new TrustManager[]{new TrustAnyTrustManager()};
            SSLContext sslContext = SSLContext.getInstance("TLS", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new HttpClientException(e.getMessage(), e);
        }
    }

    protected HttpURLConnection getHttpConnection(String httpMethod) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        HttpClientRequest httpClientRequest = this.clientRequestTL.get();
        URL url = null;
        HttpURLConnection conn = null;
        String contentType = httpClientRequest.getContentType();
        if (contentType.contains(ContentType.JSON.value())) {
            if (httpMethod.equals("GET") || httpMethod.equals("DELETE")) {
                url = !"".equals(httpClientRequest.getJsonParam()) ? new URL(this.apiUrl + httpClientRequest.getEncodedRestPath() + "?" + httpClientRequest.getEncodedJsonParam()) : new URL(this.apiUrl + httpClientRequest.getEncodedRestPath());
                conn = this.openHttpURLConnection(url, httpClientRequest, httpMethod);
            } else {
                conn = this.getStreamConnection(httpMethod, httpClientRequest);
                this.outputParam(conn, httpMethod, httpClientRequest.getJsonParam(), httpClientRequest.getEncoding());
            }
        } else if (contentType.contains(ContentType.MULTIPART.value()) || httpMethod.equals("POST")) {
            conn = this.getStreamConnection(httpMethod, httpClientRequest);
            Map<String, HttpClientFile> uploadFiles = httpClientRequest.getUploadFiles();
            if (uploadFiles != null && uploadFiles.size() > 0) {
                String boundary = "---------------------------" + HttpClientConnection.getRandomString(13);
                conn.setRequestProperty("Content-Type", contentType + "boundary=" + boundary);
                Map<String, String> params = httpClientRequest.getParams();
                DataOutputStream writer = new DataOutputStream(conn.getOutputStream());
                if (params != null && params.size() > 0) {
                    StringBuilder builder = new StringBuilder();
                    String value = null;
                    for (String key : params.keySet()) {
                        value = params.get(key);
                        if (value == null) continue;
                        builder.append("\r\n").append("--").append(boundary).append("\r\n");
                        builder.append("Content-Disposition: form-data; name=\"").append(key).append("\"\r\n\r\n");
                        builder.append(value);
                    }
                    writer.write(builder.toString().getBytes());
                }
                this.writeUploadFiles(boundary, uploadFiles, writer);
                byte[] endData = ("\r\n--" + boundary + "--\r\n").getBytes();
                writer.write(endData);
                writer.flush();
                writer.close();
            } else {
                this.outputParam(conn, httpMethod, httpClientRequest.getEncodedParams(), httpClientRequest.getEncoding());
            }
        } else {
            url = new URL(this.apiUrl + httpClientRequest.getEncodedUrl());
            conn = this.openHttpURLConnection(url, httpClientRequest, httpMethod);
        }
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(this.sslSocketFactory);
            ((HttpsURLConnection)conn).setHostnameVerifier(this.trustAnyHostnameVerifier);
        }
        conn.setConnectTimeout(httpClientRequest.getConnectTimeOut());
        conn.setReadTimeout(httpClientRequest.getReadTimeOut());
        return conn;
    }

    private HttpURLConnection getStreamConnection(String httpMethod, HttpClientRequest httpClientRequest) throws IOException {
        URL url = new URL(this.apiUrl + httpClientRequest.getEncodedRestPath());
        HttpURLConnection conn = this.openHttpURLConnection(url, httpClientRequest, httpMethod);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        return conn;
    }

    private void outputParam(HttpURLConnection conn, String method, String requestParams, String encoding) throws IOException {
        if (requestParams != null && !"".equals(requestParams)) {
            DataOutputStream writer = new DataOutputStream(conn.getOutputStream());
            logger.debug("Request out method " + method + ",out parameters " + requestParams);
            writer.write(requestParams.getBytes(encoding));
            writer.flush();
            writer.close();
        }
    }

    private void writeUploadFiles(String boundary, Map<String, HttpClientFile> uploadFiles, DataOutputStream writer) throws IOException {
        for (String key : uploadFiles.keySet()) {
            HttpClientFile httpClientFile = uploadFiles.get(key);
            if (httpClientFile == null) continue;
            writer.write(("\r\n--" + boundary + "\r\n" + "Content-Disposition: form-data; name=\"" + key + "\"; filename=\"" + httpClientFile.getName() + "\"\r\n" + "Content-Type:" + httpClientFile.getContentType() + "\r\n\r\n").getBytes());
            DataInputStream in = new DataInputStream(httpClientFile.getInputStream());
            int bytes = 0;
            byte[] bufferOut = new byte[1024];
            while ((bytes = in.read(bufferOut)) != -1) {
                writer.write(bufferOut, 0, bytes);
            }
            in.close();
        }
    }

    private HttpURLConnection openHttpURLConnection(URL url, HttpClientRequest httpClientRequest, String method) throws IOException {
        Map<String, String> headers;
        File file;
        logger.info("Open connection for api " + url.getPath());
        HttpURLConnection.setFollowRedirects(true);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        String downloadFile = httpClientRequest.getDownloadFile();
        if (downloadFile != null && (file = new File(downloadFile)).exists()) {
            conn.setRequestProperty("RANGE", "bytes=" + file.length() + "-");
        }
        if ((headers = httpClientRequest.getHeaders()) != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        logger.info("Hold cookie: %s.", new Object[]{this.cookieManager.getCookieStore().getCookies()});
        conn.setRequestProperty("Content-Type", httpClientRequest.getContentType());
        conn.setRequestProperty("User-Agent", httpClientRequest.getUserAgent());
        return conn;
    }

    private class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }

    private class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

