/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.client;

import cn.dreampie.client.HttpClientConnection;
import cn.dreampie.client.HttpClientRequest;
import cn.dreampie.client.HttpClientRequire;
import cn.dreampie.client.HttpClientResult;
import cn.dreampie.client.HttpClientUser;
import cn.dreampie.client.exception.HttpClientException;
import cn.dreampie.common.http.result.HttpStatus;
import cn.dreampie.common.util.stream.FileRenamer;
import cn.dreampie.common.util.stream.StreamReader;
import cn.dreampie.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;

public class HttpClient
extends HttpClientConnection {
    private static final Logger logger = Logger.getLogger(HttpClient.class);
    private HttpClientRequire httpClientRequire;

    public HttpClient(String apiUrl) {
        super(apiUrl);
    }

    public HttpClient(String apiUrl, String loginApi, HttpClientUser user) {
        this(apiUrl, new HttpClientRequest(loginApi, user.reserveMap()), (HttpClientRequire)null);
    }

    public HttpClient(String apiUrl, HttpClientRequire httpClientRequire) {
        this(apiUrl, null, httpClientRequire);
    }

    public HttpClient(String apiUrl, String loginApi, HttpClientUser user, HttpClientRequire httpClientRequire) {
        this(apiUrl, new HttpClientRequest(loginApi, user.reserveMap()), httpClientRequire);
    }

    public HttpClient(String apiUrl, HttpClientRequest loginRequest, HttpClientRequire httpClientRequire) {
        this(apiUrl, loginRequest, null, httpClientRequire);
    }

    public HttpClient(String apiUrl, HttpClientRequest loginRequest, HttpClientRequest httpClientRequest, HttpClientRequire httpClientRequire) {
        super(apiUrl, loginRequest, httpClientRequest);
        this.httpClientRequire = httpClientRequire != null ? httpClientRequire : new HttpClientRequire();
    }

    public HttpClient build(HttpClientRequest httpClientRequest) {
        if (httpClientRequest == null) {
            throw new HttpClientException("HttpClientRequest must not null.");
        }
        this.clientRequestTL.set(httpClientRequest);
        return this;
    }

    public HttpClientResult get() {
        return this.ask("GET");
    }

    public HttpClientResult post() {
        return this.ask("POST");
    }

    public HttpClientResult put() {
        return this.ask("PUT");
    }

    public HttpClientResult patch() {
        return this.ask("PATCH");
    }

    public HttpClientResult delete() {
        return this.ask("DELETE");
    }

    private HttpClientResult ask(String httpMethod) {
        HttpURLConnection conn = null;
        try {
            conn = this.getHttpConnection(httpMethod);
            conn.connect();
            HttpClientResult httpClientResult = this.readResponse(httpMethod, conn);
            return httpClientResult;
        }
        catch (Exception e) {
            Throwable cause;
            if (e instanceof HttpClientException) {
                throw (HttpClientException)e;
            }
            String message = e.getMessage();
            if (message == null && (cause = e.getCause()) != null) {
                message = cause.getMessage();
            }
            throw new HttpClientException(message, e);
        }
        finally {
            if (conn != null) {
                this.clientRequestTL.remove();
                conn.disconnect();
            }
        }
    }

    private HttpClientResult login(String httpMethod, HttpClientRequest httpClientRequest) {
        HttpClientResult result = this.build(this.loginRequest).post();
        if (result.getStatus() != HttpStatus.OK) {
            throw new HttpClientException("Login error " + result.getStatus().getCode() + ", " + result.getResult());
        }
        if (httpClientRequest != null) {
            result = this.build(httpClientRequest).ask(httpMethod);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClientResult readResponse(String httpMethod, HttpURLConnection conn) throws IOException {
        boolean isSuccess;
        int httpCode = conn.getResponseCode();
        logger.debug("Connection done. The server's response code is: %s", new Object[]{httpCode});
        InputStream is = null;
        boolean bl = isSuccess = httpCode < 400;
        if (isSuccess) {
            is = conn.getInputStream();
        }
        HttpClientResult result = null;
        HttpClientRequest httpClientRequest = (HttpClientRequest)this.clientRequestTL.get();
        try {
            if (is == null && httpCode >= 400) {
                is = conn.getErrorStream();
            }
            if (is == null) {
                logger.warn("Api " + httpClientRequest.getRestPath() + " response is null!!");
            } else {
                String downloadFile = httpClientRequest.getDownloadFile();
                if (isSuccess && downloadFile != null) {
                    File file;
                    File fileOrDirectory = new File(downloadFile);
                    if (fileOrDirectory.isDirectory()) {
                        String fileNameBefore;
                        int fileNameIndex;
                        String fileName = null;
                        String contentDisposition = conn.getHeaderField("Content-Disposition");
                        if (contentDisposition != null && (fileNameIndex = contentDisposition.indexOf(fileNameBefore = "filename=")) > -1) {
                            fileName = contentDisposition.substring(fileNameIndex + 9);
                        }
                        if (fileName == null) {
                            throw new HttpClientException("Server not return filename, you must set it.");
                        }
                        file = new File(fileOrDirectory, fileName);
                    } else {
                        file = fileOrDirectory;
                    }
                    FileRenamer fileRenamer = null;
                    if (!httpClientRequest.isOverwrite() && this.renamer != null) {
                        fileRenamer = this.renamer;
                    }
                    result = new HttpClientResult(HttpStatus.havingCode((int)httpCode), StreamReader.readFile((InputStream)is, (int)conn.getContentLength(), (File)file, (FileRenamer)fileRenamer).getPath());
                } else {
                    result = new HttpClientResult(HttpStatus.havingCode((int)httpCode), StreamReader.readString((InputStream)is, (String)httpClientRequest.getEncoding()));
                    if (this.loginRequest != null && this.httpClientRequire.relogin(result)) {
                        logger.info("Relogin to server.");
                        if (!httpClientRequest.equals(this.loginRequest)) {
                            HttpClientResult httpClientResult = this.login(httpMethod, httpClientRequest);
                            return httpClientResult;
                        }
                    }
                    logger.debug("Reading an OK (%s) response", new Object[]{httpCode});
                }
            }
            HttpClientResult httpClientResult = result;
            return httpClientResult;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

