/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.client;

import cn.dreampie.common.http.Encoding;
import cn.dreampie.common.util.Checker;
import cn.dreampie.common.util.Maper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientRequest {
    private String restPath;
    private String encoding = Encoding.UTF_8.name();
    private Map<String, String> params = Maper.of();
    private String jsonParam;
    private Map<String, String> headers = Maper.of();
    private int connectTimeOut = 10000;
    private int readTimeOut = 10000;
    private boolean overwrite = false;
    private String downloadFile;
    private Map<String, String> uploadFiles = Maper.of();
    private String contentType = "application/x-www-form-urlencoded;charset=" + this.encoding;
    private String userAgent = "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.146 Safari/537.36";

    public ClientRequest(String restPath) {
        this(restPath, Encoding.UTF_8.name());
    }

    public ClientRequest(String restPath, String encoding) {
        this(restPath, encoding, Maper.of());
    }

    public ClientRequest(String restPath, Map<String, String> params) {
        this(restPath, null, params);
    }

    public ClientRequest(String restPath, String encoding, Map<String, String> params) {
        this(restPath, encoding, params, Maper.of());
    }

    public ClientRequest(String restPath, String encoding, Map<String, String> params, Map<String, String> headers) {
        this.restPath = (String)Checker.checkNotNull((Object)restPath);
        if (encoding != null) {
            this.encoding = encoding;
        }
        this.params = params;
        this.headers = headers;
    }

    public String getRestPath() {
        return this.restPath;
    }

    public String getEncodedRestPath() throws UnsupportedEncodingException {
        String url = this.restPath;
        Matcher matcher = Pattern.compile("[^a-zA-Z0-9/?#&=]").matcher(url);
        while (matcher.find()) {
            String tmp = matcher.group();
            url = url.replaceAll(tmp, URLEncoder.encode(tmp, this.encoding));
        }
        return url;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public ClientRequest setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public ClientRequest setParams(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public ClientRequest setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public ClientRequest addParam(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ClientRequest setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public ClientRequest setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public String getJsonParam() {
        return this.jsonParam;
    }

    public ClientRequest setJsonParam(String jsonParam) {
        this.setContentType("application/json;charset=" + this.encoding);
        this.jsonParam = (String)Checker.checkNotNull((Object)jsonParam, (Object)"Json param could not be null.");
        return this;
    }

    public String getEncodedJsonParam() throws UnsupportedEncodingException {
        return URLEncoder.encode(this.jsonParam, this.encoding);
    }

    public ClientRequest addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public ClientRequest setConnectTimeOut(int connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
        return this;
    }

    public int getReadTimeOut() {
        return this.readTimeOut;
    }

    public ClientRequest setReadTimeOut(int readTimeOut) {
        this.readTimeOut = readTimeOut;
        return this;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public ClientRequest setDownloadFile(String downloadFile, boolean overwrite) {
        this.downloadFile = (String)Checker.checkNotNull((Object)downloadFile, (Object)"Download file could not be null.");
        this.overwrite = overwrite;
        return this;
    }

    public String getDownloadFile() {
        return this.downloadFile;
    }

    public ClientRequest setDownloadFile(String downloadFile) {
        this.setDownloadFile(downloadFile, false);
        return this;
    }

    public Map<String, String> getUploadFiles() {
        return this.uploadFiles;
    }

    public ClientRequest setUploadFiles(Map<String, String> uploadFiles) {
        this.uploadFiles = uploadFiles;
        this.setContentType("multipart/form-data;charset=" + this.encoding);
        return this;
    }

    public ClientRequest addUploadFile(String name, String filepath) {
        this.uploadFiles.put(name, filepath);
        this.setContentType("multipart/form-data;charset=" + this.encoding);
        return this;
    }

    public String getEncodedParams() throws UnsupportedEncodingException {
        String encodedParams = "";
        if (!this.params.isEmpty()) {
            Set<String> paramKeys = this.params.keySet();
            boolean isFirstParam = true;
            String value = null;
            for (String key : paramKeys) {
                value = this.params.get(key);
                if (value == null) continue;
                if (isFirstParam) {
                    encodedParams = encodedParams + key + "=" + URLEncoder.encode(value, this.getEncoding());
                    isFirstParam = false;
                    continue;
                }
                encodedParams = encodedParams + "&" + key + "=" + URLEncoder.encode(value, this.getEncoding());
            }
        }
        return encodedParams.trim();
    }

    public String getUnEncodedParams() {
        String params = "";
        if (!this.params.isEmpty()) {
            Set<String> paramKeys = this.params.keySet();
            boolean isFirstParam = true;
            String value = null;
            for (String key : paramKeys) {
                value = this.params.get(key);
                if (value == null) continue;
                if (isFirstParam) {
                    params = params + key + "=" + value;
                    isFirstParam = false;
                    continue;
                }
                params = params + "&" + key + "=" + value;
            }
        }
        return params.trim();
    }

    public String getEncodedUrl() throws UnsupportedEncodingException {
        String encodedUrl = this.getEncodedRestPath();
        if (!this.params.isEmpty()) {
            encodedUrl = encodedUrl + "?";
            Set<String> paramKeys = this.params.keySet();
            boolean isFirstParam = true;
            String value = null;
            for (String key : paramKeys) {
                value = this.params.get(key);
                if (value == null) continue;
                if (isFirstParam) {
                    encodedUrl = encodedUrl + key + "=" + URLEncoder.encode(value, this.getEncoding());
                    isFirstParam = false;
                    continue;
                }
                encodedUrl = encodedUrl + "&" + key + "=" + URLEncoder.encode(value, this.getEncoding());
            }
        }
        return encodedUrl.trim();
    }

    public String getUnEncodedUrl() {
        String url = this.getRestPath();
        if (!this.params.isEmpty()) {
            url = url + "?";
            Set<String> paramKeys = this.params.keySet();
            boolean isFirstParam = true;
            String value = null;
            for (String key : paramKeys) {
                value = this.params.get(key);
                if (value == null) continue;
                if (isFirstParam) {
                    url = url + key + "=" + value;
                    isFirstParam = false;
                    continue;
                }
                url = url + "&" + key + "=" + value;
            }
        }
        return url.trim();
    }
}

