/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.client;

import cn.dreampie.client.ClientRequest;
import cn.dreampie.client.exception.ClientException;
import cn.dreampie.common.util.HttpTyper;
import cn.dreampie.common.util.stream.DefaultFileRenamer;
import cn.dreampie.common.util.stream.FileRenamer;
import cn.dreampie.log.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Random;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientConnection {
    private static final Logger logger = Logger.getLogger(ClientConnection.class);
    private final SSLSocketFactory sslSocketFactory = this.initSSLSocketFactory();
    private final TrustAnyHostnameVerifier trustAnyHostnameVerifier = new TrustAnyHostnameVerifier();
    protected ClientRequest loginRequest;
    protected ThreadLocal<ClientRequest> clientRequestTL = new ThreadLocal();
    protected CookieManager cookieManager = new CookieManager();
    protected String apiUrl;
    protected FileRenamer renamer = new DefaultFileRenamer();

    protected ClientConnection(String apiUrl) {
        this(apiUrl, null);
    }

    protected ClientConnection(String apiUrl, ClientRequest loginRequest) {
        this(apiUrl, loginRequest, null);
    }

    protected ClientConnection(String apiUrl, ClientRequest loginRequest, ClientRequest clientRequest) {
        this.apiUrl = apiUrl;
        this.loginRequest = loginRequest;
        if (clientRequest != null) {
            this.clientRequestTL.set(clientRequest);
        }
        this.cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(this.cookieManager);
    }

    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public void setRenamer(FileRenamer renamer) {
        if (renamer == null) {
            throw new ClientException("FileRenamer must not null.");
        }
        this.renamer = renamer;
    }

    private SSLSocketFactory initSSLSocketFactory() {
        try {
            TrustManager[] tm = new TrustManager[]{new TrustAnyTrustManager()};
            SSLContext sslContext = SSLContext.getInstance("TLS", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    protected HttpURLConnection getHttpConnection(String httpMethod) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        ClientRequest clientRequest = this.clientRequestTL.get();
        URL url = null;
        HttpURLConnection conn = null;
        String contentType = clientRequest.getContentType();
        if (contentType.contains("application/json")) {
            if (httpMethod.equals("GET") || httpMethod.equals("DELETE")) {
                url = !"".equals(clientRequest.getJsonParam()) ? new URL(this.apiUrl + clientRequest.getEncodedRestPath() + "?" + clientRequest.getEncodedJsonParam()) : new URL(this.apiUrl + clientRequest.getEncodedRestPath());
                conn = this.openHttpURLConnection(url, clientRequest, httpMethod);
            } else {
                conn = this.getStreamConnection(httpMethod, clientRequest);
                this.outputParam(conn, httpMethod, clientRequest.getJsonParam(), clientRequest.getEncoding());
            }
        } else if (contentType.contains("multipart/form-data") || httpMethod.equals("POST")) {
            conn = this.getStreamConnection(httpMethod, clientRequest);
            Map<String, String> uploadFiles = clientRequest.getUploadFiles();
            if (uploadFiles != null && uploadFiles.size() > 0) {
                String boundary = "---------------------------" + ClientConnection.getRandomString(13);
                conn.setRequestProperty("Content-Type", contentType + "boundary=" + boundary);
                Map<String, String> params = clientRequest.getParams();
                DataOutputStream writer = new DataOutputStream(conn.getOutputStream());
                if (params != null && params.size() > 0) {
                    StringBuilder builder = new StringBuilder();
                    String value = null;
                    for (String key : params.keySet()) {
                        value = params.get(key);
                        if (value == null) continue;
                        builder.append("\r\n").append("--").append(boundary).append("\r\n");
                        builder.append("Content-Disposition: form-data; name=\"").append(key).append("\"\r\n\r\n");
                        builder.append(value);
                    }
                    writer.write(builder.toString().getBytes());
                }
                this.writeUploadFiles(boundary, clientRequest.getUploadFiles(), writer);
                byte[] endData = ("\r\n--" + boundary + "--\r\n").getBytes();
                writer.write(endData);
                writer.flush();
                writer.close();
            } else {
                this.outputParam(conn, httpMethod, clientRequest.getEncodedParams(), clientRequest.getEncoding());
            }
        } else {
            url = new URL(this.apiUrl + clientRequest.getEncodedUrl());
            conn = this.openHttpURLConnection(url, clientRequest, httpMethod);
        }
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(this.sslSocketFactory);
            ((HttpsURLConnection)conn).setHostnameVerifier(this.trustAnyHostnameVerifier);
        }
        conn.setConnectTimeout(clientRequest.getConnectTimeOut());
        conn.setReadTimeout(clientRequest.getReadTimeOut());
        return conn;
    }

    private HttpURLConnection getStreamConnection(String httpMethod, ClientRequest clientRequest) throws IOException {
        URL url = new URL(this.apiUrl + clientRequest.getEncodedRestPath());
        HttpURLConnection conn = this.openHttpURLConnection(url, clientRequest, httpMethod);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        return conn;
    }

    private void outputParam(HttpURLConnection conn, String method, String requestParams, String encoding) throws IOException {
        if (requestParams != null && !"".equals(requestParams)) {
            DataOutputStream writer = new DataOutputStream(conn.getOutputStream());
            logger.debug("Request out method " + method + ",out parameters " + requestParams);
            writer.write(requestParams.getBytes(encoding));
            writer.flush();
            writer.close();
        }
    }

    private void writeUploadFiles(String boundary, Map<String, String> params, DataOutputStream writer) throws IOException {
        String value = null;
        for (String key : params.keySet()) {
            value = params.get(key);
            if (value == null) continue;
            File file = new File(value);
            if (!file.exists()) {
                throw new FileNotFoundException("File not found " + file.getPath());
            }
            String filename = file.getName();
            String contentType = HttpTyper.getContentTypeFromExtension((String)filename);
            writer.write(("\r\n--" + boundary + "\r\n" + "Content-Disposition: form-data; name=\"" + key + "\"; filename=\"" + filename + "\"\r\n" + "Content-Type:" + contentType + "\r\n\r\n").getBytes());
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            int bytes = 0;
            byte[] bufferOut = new byte[1024];
            while ((bytes = in.read(bufferOut)) != -1) {
                writer.write(bufferOut, 0, bytes);
            }
            in.close();
        }
    }

    private HttpURLConnection openHttpURLConnection(URL url, ClientRequest clientRequest, String method) throws IOException {
        Map<String, String> headers;
        File file;
        logger.info("Open connection for api " + url.getPath());
        HttpURLConnection.setFollowRedirects(true);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        String downloadFile = clientRequest.getDownloadFile();
        if (downloadFile != null && (file = new File(downloadFile)).exists()) {
            conn.setRequestProperty("RANGE", "bytes=" + file.length() + "-");
        }
        if ((headers = clientRequest.getHeaders()) != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        logger.info("Hold cookie: %s.", new Object[]{this.cookieManager.getCookieStore().getCookies()});
        conn.setRequestProperty("Content-Type", clientRequest.getContentType());
        conn.setRequestProperty("User-Agent", clientRequest.getUserAgent());
        return conn;
    }

    private class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }

    private class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

