/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.client;

import cn.dreampie.client.ClientConnection;
import cn.dreampie.client.ClientRequest;
import cn.dreampie.client.ClientResult;
import cn.dreampie.client.exception.ClientException;
import cn.dreampie.common.http.result.HttpStatus;
import cn.dreampie.common.util.Maper;
import cn.dreampie.common.util.stream.FileRenamer;
import cn.dreampie.common.util.stream.StreamReader;
import cn.dreampie.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;

public class Client
extends ClientConnection {
    private static final Logger logger = Logger.getLogger(Client.class);

    public Client(String apiUrl) {
        super(apiUrl);
    }

    public Client(String apiUrl, String loginApi, String username, String password) {
        super(apiUrl, new ClientRequest(loginApi, Maper.of((Object)"username", (Object)username, (Object)"password", (Object)password)));
    }

    public Client(String apiUrl, String loginApi, String username, String password, boolean rememberMe) {
        super(apiUrl, new ClientRequest(loginApi, Maper.of((Object)"username", (Object)username, (Object)"password", (Object)password, (Object)"rememberMe", (Object)Boolean.toString(rememberMe))));
    }

    public Client(String apiUrl, String loginApi, String usernamePara, String username, String passwordPara, String password) {
        super(apiUrl, new ClientRequest(loginApi, Maper.of((Object)usernamePara, (Object)username, (Object)passwordPara, (Object)password)));
    }

    public Client(String apiUrl, String loginApi, String usernamePara, String username, String passwordPara, String password, String rememberMePara, boolean rememberMe) {
        super(apiUrl, new ClientRequest(loginApi, Maper.of((Object)usernamePara, (Object)username, (Object)passwordPara, (Object)password, (Object)rememberMePara, (Object)Boolean.toString(rememberMe))));
    }

    public Client build(ClientRequest clientRequest) {
        if (clientRequest == null) {
            throw new ClientException("ClientRequest must not null.");
        }
        this.clientRequestTL.set(clientRequest);
        return this;
    }

    public ClientResult get() {
        return this.ask("GET");
    }

    public ClientResult post() {
        return this.ask("POST");
    }

    public ClientResult put() {
        return this.ask("PUT");
    }

    public ClientResult patch() {
        return this.ask("PATCH");
    }

    public ClientResult delete() {
        return this.ask("DELETE");
    }

    private ClientResult ask(String httpMethod) {
        HttpURLConnection conn = null;
        try {
            conn = this.getHttpConnection(httpMethod);
            conn.connect();
            ClientResult clientResult = this.readResponse(conn);
            return clientResult;
        }
        catch (Exception e) {
            Throwable cause;
            if (e instanceof ClientException) {
                throw (ClientException)e;
            }
            String message = e.getMessage();
            if (message == null && (cause = e.getCause()) != null) {
                message = cause.getMessage();
            }
            throw new ClientException(message, e);
        }
        finally {
            if (conn != null) {
                this.clientRequestTL.remove();
                conn.disconnect();
            }
        }
    }

    private ClientResult login(ClientRequest clientRequest) {
        ClientResult result = this.build(this.loginRequest).post();
        if (result.getStatus() != HttpStatus.OK) {
            throw new ClientException("Login error " + result.getStatus() + ", " + result.getResult());
        }
        if (clientRequest != null) {
            result = this.build(clientRequest).post();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientResult readResponse(HttpURLConnection conn) throws IOException {
        int httpCode = conn.getResponseCode();
        logger.debug("Connection done. The server's response code is: %s", new Object[]{httpCode});
        InputStream is = null;
        ClientRequest clientRequest = (ClientRequest)this.clientRequestTL.get();
        try {
            if (httpCode == 200 || httpCode == 206) {
                logger.debug("Reading an OK (%s) response", new Object[]{httpCode});
                is = conn.getInputStream();
            } else if (httpCode == 404) {
                logger.debug("Reading a Not Found (%s) response", new Object[]{httpCode});
            } else {
                if (httpCode == 204) {
                    logger.debug("Returning a No Content (null) (%s) response", new Object[]{httpCode});
                    ClientResult clientResult = null;
                    return clientResult;
                }
                if (this.loginRequest != null && httpCode == 401) {
                    logger.info("Relogin to server.");
                    if (!clientRequest.equals(this.loginRequest)) {
                        ClientResult clientResult = this.login(clientRequest);
                        return clientResult;
                    }
                }
            }
            if (is == null) {
                is = conn.getErrorStream();
                if (is == null) {
                    logger.warn("Api " + clientRequest.getRestPath() + " response is null!!");
                }
            } else {
                String downloadFile = clientRequest.getDownloadFile();
                if (downloadFile != null) {
                    File file;
                    File fileOrDirectory = new File(downloadFile);
                    if (fileOrDirectory.isDirectory()) {
                        String fileNameBefore;
                        int fileNameIndex;
                        String fileName = null;
                        String contentDisposition = conn.getHeaderField("Content-Disposition");
                        if (contentDisposition != null && (fileNameIndex = contentDisposition.indexOf(fileNameBefore = "filename=")) > -1) {
                            fileName = contentDisposition.substring(fileNameIndex + 9);
                        }
                        if (fileName == null) {
                            throw new ClientException("Server not return filename, you must set it.");
                        }
                        file = new File(fileOrDirectory, fileName);
                    } else {
                        file = fileOrDirectory;
                    }
                    FileRenamer fileRenamer = null;
                    if (!clientRequest.isOverwrite() && this.renamer != null) {
                        fileRenamer = this.renamer;
                    }
                    ClientResult clientResult = new ClientResult(HttpStatus.havingCode((int)httpCode), StreamReader.readFile((InputStream)is, (int)conn.getContentLength(), (File)file, (FileRenamer)fileRenamer).getPath());
                    return clientResult;
                }
            }
            ClientResult clientResult = new ClientResult(HttpStatus.havingCode((int)httpCode), StreamReader.readString((InputStream)is));
            return clientResult;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

