/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.cache.redis;

import cn.dreampie.cache.CacheEvent;
import cn.dreampie.cache.CacheProvider;
import cn.dreampie.common.util.properties.Prop;
import cn.dreampie.common.util.properties.Proper;
import cn.dreampie.common.util.serialize.Serializer;
import cn.dreampie.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.util.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisProvider
extends CacheProvider {
    private static final Logger logger = Logger.getLogger(RedisProvider.class);
    private static final Pool pool;
    private static final String host;
    private static final int timeout;
    private static final int expired;

    private ShardedJedis getShardedJedis() {
        ShardedJedis shardedJedis = null;
        if (pool != null && pool instanceof ShardedJedisPool) {
            shardedJedis = (ShardedJedis)pool.getResource();
        }
        return shardedJedis;
    }

    private Jedis getJedis() {
        Jedis jedis = null;
        if (pool != null && pool instanceof JedisPool) {
            jedis = (Jedis)pool.getResource();
        }
        if (jedis == null) {
            String[] hp = host.split(":");
            jedis = new Jedis(hp[0], Integer.parseInt(hp[1]), timeout);
            if (hp.length >= 3) {
                jedis.auth(hp[3]);
            }
        }
        return jedis;
    }

    private void returnResource(ShardedJedis shardedJedis, Jedis jedis) {
        if (pool != null) {
            if (shardedJedis != null) {
                pool.returnResource((Object)shardedJedis);
            }
            if (jedis != null) {
                pool.returnResource((Object)jedis);
            }
        } else if (jedis != null) {
            jedis.disconnect();
        }
    }

    private String getRedisKey(String group, String key) {
        return group + "::" + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getCache(String group, String key) {
        Object object;
        String jkey = this.getRedisKey(group, key);
        ShardedJedis shardedJedis = null;
        Jedis jedis = null;
        try {
            shardedJedis = this.getShardedJedis();
            Object cahe = null;
            if (shardedJedis != null) {
                cahe = Serializer.unserialize((byte[])shardedJedis.get(jkey.getBytes()));
            } else {
                jedis = this.getJedis();
                if (jedis != null) {
                    cahe = Serializer.unserialize((byte[])jedis.get(jkey.getBytes()));
                }
            }
            object = cahe;
            this.returnResource(shardedJedis, jedis);
        }
        catch (Exception e) {
            T t;
            try {
                logger.warn("%s", (Throwable)e, new Object[]{e});
                t = null;
                this.returnResource(shardedJedis, jedis);
            }
            catch (Throwable throwable) {
                this.returnResource(shardedJedis, jedis);
                throw throwable;
            }
            return t;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCache(String group, String key, Object cache, int expired) {
        ShardedJedis shardedJedis = null;
        Jedis jedis = null;
        try {
            byte[] jkey = this.getRedisKey(group, key).getBytes();
            shardedJedis = this.getShardedJedis();
            if (shardedJedis != null) {
                shardedJedis.set(jkey, Serializer.serialize((Object)cache));
                if (expired != -1) {
                    shardedJedis.expire(jkey, expired);
                } else if (RedisProvider.expired != -1) {
                    shardedJedis.expire(jkey, RedisProvider.expired);
                }
            } else {
                jedis = this.getJedis();
                if (jedis != null) {
                    jedis.set(jkey, Serializer.serialize((Object)cache));
                    if (expired != -1) {
                        jedis.expire(jkey, expired);
                    } else if (RedisProvider.expired != -1) {
                        jedis.expire(jkey, RedisProvider.expired);
                    }
                }
            }
            this.returnResource(shardedJedis, jedis);
        }
        catch (Exception e) {
            try {
                logger.warn("%s", (Throwable)e, new Object[]{e});
                this.returnResource(shardedJedis, jedis);
            }
            catch (Throwable throwable) {
                this.returnResource(shardedJedis, jedis);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCache(String group, String key) {
        String jkey = this.getRedisKey(group, key);
        ShardedJedis shardedJedis = null;
        Jedis jedis = null;
        try {
            shardedJedis = this.getShardedJedis();
            if (shardedJedis != null) {
                shardedJedis.del(jkey.getBytes());
            } else {
                jedis = this.getJedis();
                if (jedis != null) {
                    jedis.del(jkey.getBytes());
                }
            }
            this.returnResource(shardedJedis, jedis);
        }
        catch (Exception e) {
            try {
                logger.warn("%s", (Throwable)e, new Object[]{e});
                this.returnResource(shardedJedis, jedis);
            }
            catch (Throwable throwable) {
                this.returnResource(shardedJedis, jedis);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFlush(CacheEvent event) {
        ShardedJedis shardedJedis = null;
        Jedis jedis = null;
        try {
            shardedJedis = this.getShardedJedis();
            if (shardedJedis != null) {
                if (event.getType().equals((Object)CacheEvent.CacheEventType.ALL)) {
                    Collection shards = shardedJedis.getAllShards();
                    for (Jedis j : shards) {
                        j.flushDB();
                    }
                } else if (event.getType().equals((Object)CacheEvent.CacheEventType.GROUP)) {
                    Collection shards = shardedJedis.getAllShards();
                    for (Jedis j : shards) {
                        this.delGroup(j, event);
                    }
                }
            } else {
                jedis = this.getJedis();
                if (jedis != null) {
                    if (event.getType().equals((Object)CacheEvent.CacheEventType.ALL)) {
                        jedis.flushDB();
                    } else if (event.getType().equals((Object)CacheEvent.CacheEventType.GROUP)) {
                        this.delGroup(jedis, event);
                    }
                }
            }
            this.returnResource(shardedJedis, jedis);
        }
        catch (Exception e) {
            try {
                logger.warn("%s", (Throwable)e, new Object[]{e});
                this.returnResource(shardedJedis, jedis);
            }
            catch (Throwable throwable) {
                this.returnResource(shardedJedis, jedis);
                throw throwable;
            }
        }
    }

    private void delGroup(Jedis jedis, CacheEvent event) {
        Set keySet = jedis.keys(event.getGroup() + "::" + '*');
        if (keySet != null && keySet.size() > 0) {
            String[] keys = new String[keySet.size()];
            jedis.del(keySet.toArray(keys));
        }
    }

    static {
        Prop config = null;
        try {
            config = Proper.use((String)"redis.properties");
        }
        catch (Exception ignore) {
            logger.warn(ignore.getMessage());
        }
        if (config != null) {
            String shardHost = config.get("redis.shard.host");
            host = config.get("redis.host");
            timeout = config.getInt("redis.timeout", Integer.valueOf(2000));
            expired = config.getInt("redis.expired", Integer.valueOf(-1));
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setLifo(config.getBoolean("redis.pool.lifo", Boolean.valueOf(true)).booleanValue());
            poolConfig.setMaxWaitMillis(config.getLong("redis.pool.maxWaitMillis", Long.valueOf(-1L)).longValue());
            poolConfig.setMinEvictableIdleTimeMillis(config.getLong("redis.pool.minEvictableIdleTimeMillis", Long.valueOf(1800000L)).longValue());
            poolConfig.setSoftMinEvictableIdleTimeMillis(config.getLong("redis.pool.softMinEvictableIdleTimeMillis", Long.valueOf(-1L)).longValue());
            poolConfig.setNumTestsPerEvictionRun(config.getInt("redis.pool.numTestsPerEvictionRun", Integer.valueOf(3)).intValue());
            poolConfig.setTestOnBorrow(config.getBoolean("redis.pool.testOnBorrow", Boolean.valueOf(false)).booleanValue());
            poolConfig.setTestOnReturn(config.getBoolean("redis.pool.testOnReturn", Boolean.valueOf(false)).booleanValue());
            poolConfig.setTestWhileIdle(config.getBoolean("redis.pool.testWhileIdle", Boolean.valueOf(false)).booleanValue());
            poolConfig.setTimeBetweenEvictionRunsMillis(config.getLong("redis.pool.timeBetweenEvictionRunsMillis", Long.valueOf(-1L)).longValue());
            poolConfig.setEvictionPolicyClassName(config.get("redis.pool.evictionPolicyClassName", "org.apache.commons.pool2.impl.DefaultEvictionPolicy"));
            poolConfig.setBlockWhenExhausted(config.getBoolean("redis.pool.blockWhenExhausted", Boolean.valueOf(true)).booleanValue());
            poolConfig.setJmxEnabled(config.getBoolean("redis.pool.jmxEnabled", Boolean.valueOf(true)).booleanValue());
            poolConfig.setJmxNamePrefix(config.get("redis.pool.jmxNamePrefix", "pool"));
            if (shardHost != null) {
                String[] shards = shardHost.split(",");
                ArrayList<JedisShardInfo> shardInfos = new ArrayList<JedisShardInfo>();
                for (String s : shards) {
                    String[] hp = s.split(":");
                    JedisShardInfo shardInfo = new JedisShardInfo(hp[0], Integer.parseInt(hp[1]), timeout);
                    if (hp.length >= 3) {
                        shardInfo.setPassword(hp[3]);
                    }
                    shardInfos.add(shardInfo);
                }
                pool = new ShardedJedisPool((GenericObjectPoolConfig)poolConfig, shardInfos);
            } else if (host != null) {
                String[] hp = host.split(":");
                pool = new JedisPool((GenericObjectPoolConfig)poolConfig, hp[0], Integer.parseInt(hp[1]));
            } else {
                pool = null;
                logger.error("Could not found 'redis.host' or 'redis.shard.host'");
            }
        } else {
            host = "127.0.0.1:6379";
            pool = null;
            timeout = 2000;
            expired = -1;
        }
    }
}

