/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.cache.ehcache;

import cn.dreampie.cache.CacheEvent;
import cn.dreampie.cache.CacheProvider;
import cn.dreampie.log.Logger;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EHCacheProvider
extends CacheProvider {
    private static final Logger logger = Logger.getLogger(EHCacheProvider.class);
    private final CacheManager cacheManager;

    public EHCacheProvider() {
        this.cacheManager = CacheManager.create();
    }

    public EHCacheProvider(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public EHCacheProvider(String configurationFileName) {
        this(EHCacheProvider.class.getResourceAsStream(configurationFileName));
    }

    public EHCacheProvider(URL configurationFileURL) {
        this.cacheManager = CacheManager.create((URL)configurationFileURL);
    }

    public EHCacheProvider(InputStream inputStream) {
        this.cacheManager = CacheManager.create((InputStream)inputStream);
    }

    public EHCacheProvider(Configuration configuration) {
        this.cacheManager = CacheManager.create((Configuration)configuration);
    }

    @Override
    public <T> T getCache(String group, String key) {
        try {
            this.createIfMissing(group);
            Cache c = this.cacheManager.getCache(group);
            return (T)(c.get((Serializable)((Object)key)) == null ? null : c.get((Serializable)((Object)key)).getObjectValue());
        }
        catch (Exception e) {
            logger.warn("%s", (Throwable)e, new Object[]{e});
            return null;
        }
    }

    private void createIfMissing(String group) {
        if (this.cacheManager.getCache(group) == null) {
            try {
                this.cacheManager.addCache(group);
            }
            catch (Exception ignore) {
                logger.warn(ignore.getMessage());
            }
        }
    }

    @Override
    public void addCache(String group, String key, Object cache, int expired) {
        this.createIfMissing(group);
        Element element = expired != -1 ? new Element((Object)key, cache, Boolean.valueOf(false), Integer.valueOf(expired), Integer.valueOf(expired)) : new Element((Object)key, cache);
        this.cacheManager.getCache(group).put(element);
    }

    @Override
    public void removeCache(String group, String key) {
        if (this.cacheManager.getCache(group) != null) {
            this.cacheManager.getCache(group).remove((Serializable)((Object)key));
        }
    }

    @Override
    public void doFlush(CacheEvent event) {
        if (event.getType().equals((Object)CacheEvent.CacheEventType.ALL)) {
            this.cacheManager.removalAll();
        } else if (event.getType().equals((Object)CacheEvent.CacheEventType.GROUP)) {
            this.cacheManager.removeCache(event.getGroup());
        }
    }
}

