/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.cache;

import cn.dreampie.cache.CacheEvent;
import cn.dreampie.cache.CacheEventListener;
import cn.dreampie.cache.ehcache.EHCacheProvider;
import cn.dreampie.common.Constant;
import cn.dreampie.log.Logger;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheProvider {
    public static final CacheProvider PROVIDER;
    private static final Logger logger;
    List<CacheEventListener> listeners = new ArrayList<CacheEventListener>();

    public abstract <T> T getCache(String var1, String var2);

    public void addCache(String group, String key, Object cache) {
        this.addCache(group, key, cache, -1);
    }

    public abstract void addCache(String var1, String var2, Object var3, int var4);

    public abstract void removeCache(String var1, String var2);

    public abstract void doFlush(CacheEvent var1);

    public final void flush(CacheEvent event) {
        this.doFlush(event);
        for (CacheEventListener listener : this.listeners) {
            try {
                listener.onFlush(event);
            }
            catch (Exception e) {
                logger.warn("Failed to propagate cache event: %s to listener: %s", new Object[]{event, listener, e});
            }
        }
        if (logger.isDebugEnabled()) {
            String message = "Cache purged: " + (event.getType() == CacheEvent.CacheEventType.ALL ? "all caches" : "group '" + event.getGroup() + "'");
            logger.debug(message);
        }
    }

    public final void addCacheEventListener(CacheEventListener listener) {
        this.listeners.add(listener);
    }

    public final void removeCacheEventListener(CacheEventListener listener) {
        this.listeners.remove(listener);
    }

    public final void removeAllCacheEventListeners() {
        this.listeners = new ArrayList<CacheEventListener>();
    }

    static {
        logger = Logger.getLogger(CacheProvider.class);
        CacheProvider cacheProvider = null;
        if (Constant.cacheEnabled) {
            if (Constant.cacheProvider == null) {
                cacheProvider = new EHCacheProvider();
            } else {
                try {
                    Class<?> cacheClass = Class.forName(Constant.cacheProvider);
                    cacheProvider = (CacheProvider)cacheClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    logger.error("Could not found CacheProvider Class.", (Throwable)e);
                }
                catch (InstantiationException e) {
                    logger.error("Could not init CacheProvider Class.", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    logger.error("Could not access CacheProvider Class.", (Throwable)e);
                }
            }
        }
        PROVIDER = cacheProvider;
    }
}

