/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie;

import cn.dreampie.ClosureMinifier;
import cn.dreampie.FileUtilities;
import cn.dreampie.LogKit;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="minify", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class MinifierMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}/src/main/javascript")
    private File sourceDirectory;
    @Parameter
    private File[] includeFiles;
    @Parameter
    private File[] excludeFiles;
    @Parameter(defaultValue="${project.basedir}/src/main/webapp/javascript/${project.artifactId}-${project.version}.min.js")
    private File outputFile;
    @Parameter(defaultValue="${project.basedir}/src/main/webapp/javascript")
    private File outputDirectory;
    @Parameter(defaultValue="false")
    private boolean merge;
    @Parameter(defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        LogKit.setLog(this.getLog());
        try {
            List<Object> filesToMinify;
            this.getLog().info((CharSequence)"Minifying all Javascript Files in the Output Directory");
            ClosureMinifier minifier = new ClosureMinifier();
            minifier.setSourceDirectory(this.sourceDirectory);
            if (null != this.includeFiles) {
                filesToMinify = Lists.newArrayList((Object[])this.includeFiles);
                this.getLog().info((CharSequence)("About to include the following files:  " + FileUtilities.getCommaSeparatedListOfFileNames((List<File>)filesToMinify)));
            } else {
                this.getLog().debug((CharSequence)"No file to include,use sourceDirectory.");
                filesToMinify = FileUtilities.directoryToFileList(this.sourceDirectory);
            }
            List<Object> filesToMinifyMinusDestFile = null;
            filesToMinifyMinusDestFile = null != this.excludeFiles ? this.getMinifyFiles((List<File>)filesToMinify, Lists.newArrayList((Object[])this.excludeFiles)) : filesToMinify;
            if (filesToMinifyMinusDestFile != null && filesToMinifyMinusDestFile.size() > 0) {
                this.getLog().info((CharSequence)("About to minify the following files:  " + FileUtilities.getCommaSeparatedListOfFileNames(filesToMinifyMinusDestFile)));
            } else {
                this.getLog().info((CharSequence)"No file  to minify.");
            }
            if (this.merge) {
                minifier.compile(filesToMinifyMinusDestFile, this.outputFile);
            } else {
                minifier.setOutputDirectory(this.outputDirectory);
                minifier.compile(filesToMinifyMinusDestFile);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private List<File> getMinifyFiles(List<File> filesToMinify, List<File> outFiles) {
        if (outFiles != null && outFiles.size() > 0) {
            this.getLog().info((CharSequence)("About to exclude the following files:  " + FileUtilities.getCommaSeparatedListOfFileNames(outFiles)));
            ArrayList filesToMinifyMinusDestFile = Lists.newArrayList();
            for (File file : filesToMinify) {
                if (file.isDirectory()) {
                    filesToMinifyMinusDestFile.addAll(FileUtilities.directoryToFileList(file));
                    continue;
                }
                filesToMinifyMinusDestFile.add(file);
            }
            for (File outFile : outFiles) {
                if (!outFile.isDirectory()) continue;
                if (outFile.isDirectory()) {
                    filesToMinifyMinusDestFile.removeAll(FileUtilities.directoryToFileList(outFile));
                    continue;
                }
                filesToMinifyMinusDestFile.remove(outFile);
            }
            return filesToMinifyMinusDestFile;
        }
        this.getLog().info((CharSequence)"No file to exclude.");
        return filesToMinify;
    }
}

