/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.maven.model.FileSet;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtilities {
    public static List<File> getFilesFromFileSet(FileSet fileSet) throws IOException {
        List files = Lists.newArrayList();
        try {
            File directory = new File(fileSet.getDirectory());
            String includes = FileUtilities.getCommaSeparatedList(fileSet.getIncludes());
            String excludes = FileUtilities.getCommaSeparatedList(fileSet.getExcludes());
            files = FileUtils.getFiles((File)directory, (String)includes, (String)excludes);
        }
        catch (IOException e) {
            throw new IOException("Unable to access files in fileSet", e);
        }
        return files;
    }

    public static String getCommaSeparatedList(List<String> list) {
        StringBuffer sb = new StringBuffer();
        Iterator<String> i = list.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String getCommaSeparatedListOfFileNames(List<File> fileList) {
        StringBuffer sb = new StringBuffer();
        Iterator<File> i = fileList.iterator();
        while (i.hasNext()) {
            sb.append(i.next().getAbsolutePath());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static List<File> directoryToFileList(String sourceDirectory) {
        File srcDir = new File(sourceDirectory);
        return FileUtilities.getDirFiles(srcDir);
    }

    public static List<File> directoryToFileList(File sourceDirectory) {
        return FileUtilities.getDirFiles(sourceDirectory);
    }

    private static List<File> getDirFiles(File srcDir) {
        ArrayList files = Lists.newArrayList();
        if (srcDir.exists() && srcDir.isDirectory()) {
            File[] dirs;
            File[] filesInSrcDir;
            for (File file : filesInSrcDir = srcDir.listFiles((FileFilter)new SuffixFileFilter(".js"))) {
                files.add(file);
            }
            for (File file : dirs = srcDir.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY)) {
                files.addAll(FileUtilities.getDirFiles(file));
            }
        }
        return files;
    }

    public static List<File> fileToFileList(String sourceFile) {
        ArrayList files = Lists.newArrayList();
        File srcFile = new File(sourceFile);
        if (srcFile.exists() && srcFile.isFile()) {
            files.add(srcFile);
        }
        return files;
    }

    public static List<File> fileSetToFileList(FileSet fileset) throws IOException {
        return FileUtilities.getFilesFromFileSet(fileset);
    }

    public static void main(String[] args) {
        File file = new File("/home/ice/IdeaProjects/icedog/src/main/webapp/javascript/min/a.js");
        System.out.println(file.getParentFile().mkdir());
    }
}

