/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie;

import cn.dreampie.ClosureException;
import cn.dreampie.LogKit;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureMinifier {
    private Log log = LogKit.getLog();
    private CompilationLevel compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
    private File sourceDirectory;
    private File outputDirectory;

    public void compile(List<File> filesToCompile, File destFile) {
        Compiler compiler = new Compiler();
        Result result = compiler.compile(this.getExterns(), this.getInputs(filesToCompile), this.getCompilerOptions());
        this.compile(result, destFile, compiler);
    }

    public void compile(List<File> filesToCompile) {
        File destFile = null;
        Result result = null;
        Compiler compiler = null;
        for (File file : filesToCompile) {
            compiler = new Compiler();
            destFile = this.prepareDestFile(file);
            this.log.info((CharSequence)("Compile " + destFile.getAbsolutePath()));
            result = compiler.compile(this.getExterns(), (List)Lists.newArrayList((Object[])new SourceFile[]{this.getInput(file)}), this.getCompilerOptions());
            this.compile(result, destFile, compiler);
        }
    }

    private void compile(Result result, File destFile, Compiler compiler) {
        this.log.debug((CharSequence)result.debugLog);
        for (JSError error : result.errors) {
            this.log.error((CharSequence)("Closure Minifier Error:  " + error.sourceName + "  Description:  " + error.description));
        }
        for (JSError warning : result.warnings) {
            this.log.info((CharSequence)("Closure Minifier Warning:  " + warning.sourceName + "  Description:  " + warning.description));
        }
        if (result.success) {
            try {
                Files.write((CharSequence)compiler.toSource(), (File)destFile, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                throw new ClosureException("Failed to write minified file to " + destFile, e);
            }
        } else {
            throw new ClosureException("Closure Compiler Failed - See error messages on System.err");
        }
    }

    private File prepareDestFile(File file) {
        String path = file.getAbsolutePath().replace(this.sourceDirectory.getAbsolutePath(), "");
        File f = new File(this.outputDirectory, path.replace(".js", ".min.js"));
        File dir = f.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return f;
    }

    private CompilerOptions getCompilerOptions() {
        CompilationLevel level = null;
        try {
            level = this.compilationLevel;
        }
        catch (IllegalArgumentException e) {
            throw new ClosureException("Compilation level is invalid", e);
        }
        CompilerOptions options = new CompilerOptions();
        level.setOptionsForCompilationLevel(options);
        return options;
    }

    private List<SourceFile> getExterns() {
        try {
            return CommandLineRunner.getDefaultExterns();
        }
        catch (IOException e) {
            throw new ClosureException("Unable to load default External variables Files. The files include definitions for global javascript/browser objects such as window, document.", e);
        }
    }

    private List<SourceFile> getInputs(List<File> filesToProcess) {
        ArrayList files = Lists.newArrayList();
        for (File file : filesToProcess) {
            files.add(this.getInput(file));
        }
        return files;
    }

    private SourceFile getInput(File fileToProcess) {
        return SourceFile.fromFile((File)fileToProcess);
    }

    public CompilationLevel getCompilationLevel() {
        return this.compilationLevel;
    }

    public void setCompilationLevel(CompilationLevel compilationLevel) {
        this.compilationLevel = compilationLevel;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

