/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.resource;

import cn.dreampie.resource.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileResource
implements Resource {
    private File file;

    public FileResource(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null!");
        }
        this.file = file;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public Resource createRelative(String relativePath) {
        File relativeFile = new File(this.file.getParentFile(), relativePath);
        return new FileResource(relativeFile);
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    @Override
    public String getName() {
        return this.file.getAbsolutePath();
    }
}

