/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie;

import com.jfinal.kit.PathKit;
import com.jfinal.kit.StrKit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesKit {
    private ConcurrentMap<String, Object> propertiesAttrs = new ConcurrentHashMap<String, Object>();
    private ConcurrentMap<String, Properties> propertiesFiles = new ConcurrentHashMap<String, Properties>();
    private static PropertiesKit propertiesKit = new PropertiesKit();

    public static PropertiesKit me() {
        return propertiesKit;
    }

    public static boolean exist(String file) {
        Enumeration<URL> urls = null;
        try {
            urls = PropertiesKit.class.getClassLoader().getResources(file);
            if (urls.hasMoreElements()) {
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public List<Properties> loadPropertyFiles(String ... file) {
        ArrayList<Properties> propertieses = new ArrayList<Properties>();
        for (String path : file) {
            propertieses.add(this.loadPropertyFile(false, path));
        }
        return propertieses;
    }

    public List<Properties> loadPropertyFiles(boolean reload, String ... file) {
        ArrayList<Properties> propertieses = new ArrayList<Properties>();
        for (String path : file) {
            propertieses.add(this.loadPropertyFile(reload, path));
        }
        return propertieses;
    }

    public Properties loadPropertyFile(String file) {
        return this.loadPropertyFile(false, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadPropertyFile(boolean reload, String file) {
        Properties properties = new Properties();
        if (StrKit.isBlank((String)file)) {
            throw new IllegalArgumentException("Parameter of file can not be blank");
        }
        if (file.contains("..")) {
            throw new IllegalArgumentException("Parameter of file can not contains \"..\"");
        }
        InputStream inputStream = null;
        boolean startStuff = file.startsWith("/");
        String fullFile = startStuff ? PathKit.getWebRootPath() + File.separator + "WEB-INF" + File.separator + file.substring(1) : PathKit.getWebRootPath() + File.separator + "WEB-INF" + File.separator + file;
        File propFile = new File(fullFile);
        if (!propFile.exists()) {
            fullFile = !startStuff ? "/" + file : file;
            if (this.hasPropertiesFile(reload, fullFile)) {
                return (Properties)this.propertiesFiles.get(fullFile);
            }
            inputStream = PropertiesKit.class.getResourceAsStream(fullFile);
        } else if (this.hasPropertiesFile(reload, fullFile)) {
            return (Properties)this.propertiesFiles.get(fullFile);
        }
        try {
            if (inputStream == null) {
                inputStream = new FileInputStream(propFile);
            }
            properties.load(inputStream);
        }
        catch (Exception eOne) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                properties.load(loader.getResourceAsStream(file));
            }
            catch (IOException eTwo) {
                throw new IllegalArgumentException("Properties file loading failed: " + eTwo.getMessage());
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (properties != null) {
            this.propertiesFiles.put(fullFile, properties);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.propertiesAttrs.put(entry.getKey().toString(), entry.getValue());
            }
        }
        return properties;
    }

    private boolean hasPropertiesFile(boolean reload, String fullFile) {
        return !reload && this.propertiesFiles.containsKey(fullFile);
    }

    public String getProperty(String key) {
        if (this.propertiesAttrs.containsKey(key)) {
            return this.propertiesAttrs.get(key).toString();
        }
        return null;
    }

    public String getProperty(String key, String defaultValue) {
        if (this.propertiesAttrs.containsKey(key)) {
            return this.propertiesAttrs.get(key).toString();
        }
        return defaultValue;
    }

    public Integer getPropertyToInt(String key) {
        Integer resultInt = null;
        String resultStr = this.getProperty(key);
        if (resultStr != null) {
            resultInt = Integer.parseInt(resultStr);
        }
        return resultInt;
    }

    public Integer getPropertyToInt(String key, Integer defaultValue) {
        Integer result = this.getPropertyToInt(key);
        return result != null ? result : defaultValue;
    }

    public Boolean getPropertyToBoolean(String key) {
        String resultStr = this.getProperty(key);
        Boolean resultBool = null;
        if (resultStr != null) {
            if (resultStr.trim().equalsIgnoreCase("true")) {
                resultBool = true;
            } else if (resultStr.trim().equalsIgnoreCase("false")) {
                resultBool = false;
            }
        }
        return resultBool;
    }

    public Boolean getPropertyToBoolean(String key, boolean defaultValue) {
        Boolean result = this.getPropertyToBoolean(key);
        return result != null ? result : defaultValue;
    }
}

