/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.shiro.hasher;

import cn.dreampie.shiro.hasher.Hasher;
import cn.dreampie.shiro.hasher.HasherInfo;
import org.apache.shiro.authc.credential.DefaultPasswordService;
import org.apache.shiro.authc.credential.PasswordService;

public class HasherKit {
    private static PasswordService passwordService = new DefaultPasswordService();

    public static HasherInfo hash(String hashText) {
        return HasherKit.hash(hashText, Hasher.DEFAULT);
    }

    public static HasherInfo hash(String hashText, Hasher hasher) {
        HasherInfo hasherInfo = null;
        if (hasher == Hasher.DEFAULT) {
            hasherInfo = new HasherInfo(hashText, passwordService.encryptPassword((Object)hashText), hasher, "");
        }
        return hasherInfo;
    }

    public static boolean match(Object submittedPlaintext, String encrypted) {
        return HasherKit.match(submittedPlaintext, encrypted, Hasher.DEFAULT);
    }

    public static boolean match(Object submittedPlaintext, String encrypted, Hasher hasher) {
        boolean result = false;
        if (hasher == Hasher.DEFAULT) {
            result = passwordService.passwordsMatch(submittedPlaintext, encrypted);
        }
        return result;
    }
}

