/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.shiro.core;

import cn.dreampie.encription.EncriptionKit;
import cn.dreampie.shiro.model.User;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.subject.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectKit {
    private static String[] baseRole = new String[]{"R_ADMIN", "R_MANAGER", "R_MEMBER", "R_USER"};

    private SubjectKit() {
    }

    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static Session getSession() {
        Subject subject = SecurityUtils.getSubject();
        Session session = subject.getSession();
        if (session == null) {
            throw new UnknownSessionException("Unable found required Session");
        }
        return session;
    }

    public static <T extends User> T getUser() {
        Subject subject = SubjectKit.getSubject();
        Object user = subject.getPrincipal();
        if (user == null) {
            return null;
        }
        return (T)((Object)((User)((Object)user)));
    }

    public static boolean login(String username, String password) {
        return SubjectKit.login(username, password, false);
    }

    public static boolean login(String username, String password, boolean rememberMe) {
        UsernamePasswordToken token = new UsernamePasswordToken(username, password);
        try {
            token.setRememberMe(rememberMe);
            SecurityUtils.getSubject().login((AuthenticationToken)token);
            return true;
        }
        catch (AuthenticationException e) {
            return false;
        }
    }

    public static boolean doCaptcha(String captchaName, String captchaToken) {
        Session session = SubjectKit.getSession();
        if (session.getAttribute((Object)captchaName) != null) {
            String captcha = session.getAttribute((Object)captchaName).toString();
            if (captchaToken != null && captcha.equalsIgnoreCase(EncriptionKit.encrypt((String)captchaToken))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAuthed() {
        Subject subject = SubjectKit.getSubject();
        return subject != null && subject.getPrincipal() != null && (subject.isAuthenticated() || subject.isRemembered());
    }

    public static boolean wasBaseRole(String roleValue) {
        return ArrayUtils.contains((Object[])baseRole, (Object)roleValue);
    }

    public String[] getBaseRole() {
        return baseRole;
    }

    public void setBaseRole(String ... baseRole) {
        SubjectKit.baseRole = baseRole;
    }
}

