/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.shiro.core;

import cn.dreampie.shiro.core.ShiroKit;
import cn.dreampie.shiro.core.SubjectKit;
import cn.dreampie.shiro.core.handler.AuthzHandler;
import com.jfinal.aop.Interceptor;
import com.jfinal.core.ActionInvocation;
import java.util.List;
import javax.servlet.ServletRequest;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiroInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ShiroInterceptor.class);

    public void intercept(ActionInvocation ai) {
        List<AuthzHandler> ahs = ShiroKit.getAuthzHandler(ai.getController().getRequest(), ai.getActionKey());
        if (this.assertNoAuthorized(ai, ahs)) {
            return;
        }
        ai.invoke();
    }

    private boolean assertNoAuthorized(ActionInvocation ai, List<AuthzHandler> ahs) {
        if (ahs != null && ahs.size() > 0) {
            Object principal;
            Subject subject;
            if (!SubjectKit.isAuthed()) {
                WebUtils.saveRequest((ServletRequest)ai.getController().getRequest());
            }
            if (!(subject = SubjectKit.getSubject()).isAuthenticated() && subject.isRemembered() && (principal = subject.getPrincipal()) == null) {
                SubjectKit.getSubject().logout();
            }
            try {
                for (AuthzHandler ah : ahs) {
                    ah.assertAuthorized();
                }
            }
            catch (UnauthenticatedException lae) {
                ai.getController().renderError(401);
                return true;
            }
            catch (AuthorizationException ae) {
                ai.getController().renderError(403);
                return true;
            }
            catch (Exception e) {
                ai.getController().renderError(401);
                return true;
            }
        }
        return false;
    }
}

